/*
 * Decompiled with CFR 0.152.
 */
package liquibase.csv.opencsv.bean;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import liquibase.csv.opencsv.CSVReader;
import liquibase.csv.opencsv.bean.MappingStrategy;

public class CsvToBean {
    public List parse(MappingStrategy mappingStrategy, Reader reader) {
        try {
            String[] stringArray;
            CSVReader cSVReader = new CSVReader(reader);
            mappingStrategy.captureHeader(cSVReader);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (null != (stringArray = cSVReader.readNext())) {
                Object object = this.processLine(mappingStrategy, stringArray);
                arrayList.add(object);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing CSV!", exception);
        }
    }

    protected Object processLine(MappingStrategy mappingStrategy, String[] stringArray) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException {
        Object object = mappingStrategy.createBean();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            PropertyDescriptor propertyDescriptor = mappingStrategy.findDescriptor(i);
            if (null == propertyDescriptor) continue;
            Object object2 = this.convertValue(string, propertyDescriptor);
            propertyDescriptor.getWriteMethod().invoke(object, object2);
        }
        return object;
    }

    protected Object convertValue(String string, PropertyDescriptor propertyDescriptor) throws InstantiationException, IllegalAccessException {
        PropertyEditor propertyEditor = this.getPropertyEditor(propertyDescriptor);
        Object object = string;
        if (null != propertyEditor) {
            propertyEditor.setAsText(string);
            object = propertyEditor.getValue();
        }
        return object;
    }

    protected PropertyEditor getPropertyEditor(PropertyDescriptor propertyDescriptor) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (null != clazz) {
            return (PropertyEditor)clazz.newInstance();
        }
        return PropertyEditorManager.findEditor(propertyDescriptor.getPropertyType());
    }
}

