/*
 * Decompiled with CFR 0.152.
 */
package liquibase.csv;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import liquibase.util.ISODateFormat;

public class CSVWriter
extends liquibase.csv.opencsv.CSVWriter {
    private static final ISODateFormat ISO_DATE_FORMAT = new ISODateFormat();

    public CSVWriter(Writer writer) {
        super(writer);
    }

    public CSVWriter(Writer writer, char c) {
        super(writer, c);
    }

    public CSVWriter(Writer writer, char c, char c2) {
        super(writer, c, c2);
    }

    public CSVWriter(Writer writer, char c, char c2, char c3) {
        super(writer, c, c2, c3);
    }

    public CSVWriter(Writer writer, char c, char c2, String string) {
        super(writer, c, c2, string);
    }

    public CSVWriter(Writer writer, char c, char c2, char c3, String string) {
        super(writer, c, c2, c3, string);
    }

    public void writeAll(ResultSet resultSet, boolean bl) throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (bl) {
            this.writeColumnNames(resultSetMetaData);
        }
        int n = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.getColumnValue(resultSet, resultSetMetaData.getColumnType(i + 1), i + 1);
            }
            this.writeNext(stringArray);
        }
    }

    private String getColumnValue(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        Object object = resultSet.getObject(n2);
        if (resultSet.wasNull()) {
            return "NULL";
        }
        if (object instanceof Date) {
            return ISO_DATE_FORMAT.format((Date)object);
        }
        if (object instanceof Time) {
            return ISO_DATE_FORMAT.format((Time)object);
        }
        if (object instanceof Timestamp) {
            return ISO_DATE_FORMAT.format((Timestamp)object);
        }
        return object.toString();
    }
}

