/*
 * Decompiled with CFR 0.152.
 */
package liquibase.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.CompositeFileOpener;
import liquibase.FileOpener;
import liquibase.FileSystemFileOpener;
import liquibase.Liquibase;
import liquibase.commandline.CommandLineFileOpener;
import liquibase.commandline.CommandLineUtils;
import liquibase.database.Database;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.JDBCException;
import liquibase.exception.ValidationFailedException;
import liquibase.lock.LockHandler;
import liquibase.log.LogFactory;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    protected ClassLoader classLoader;
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String databaseClass;
    protected String defaultSchemaName;
    protected String changeLogFile;
    protected String classpath;
    protected String contexts;
    protected Boolean promptForNonLocalDatabase = null;
    protected Boolean includeSystemClasspath;
    protected String defaultsFile = "liquibase.properties";
    protected String diffTypes;
    protected String changeSetAuthor;
    protected String changeSetContext;
    protected String dataDir;
    protected String currentDateTimeFunction;
    protected String command;
    protected Set<String> commandParams = new HashSet<String>();
    protected String logLevel;
    protected String logFile;
    protected Map<String, Object> changeLogParameters = new HashMap<String, Object>();

    public static void main(String[] stringArray) throws CommandLineParsingException, IOException {
        try {
            List<String> list;
            String string = System.getProperty("liquibase.should.run");
            if (string != null && !Boolean.valueOf(string).booleanValue()) {
                System.out.println("LiquiBase did not run because 'liquibase.should.run' system property was set to false");
                return;
            }
            Main main = new Main();
            if (stringArray.length == 1 && "--help".equals(stringArray[0])) {
                main.printHelp(System.out);
                return;
            }
            if (stringArray.length == 1 && "--version".equals(stringArray[0])) {
                System.out.println("LiquiBase Version: " + LiquibaseUtil.getBuildVersion() + StreamUtil.getLineSeparator());
                return;
            }
            try {
                main.parseOptions(stringArray);
            }
            catch (CommandLineParsingException commandLineParsingException) {
                System.out.println(commandLineParsingException.getMessage());
                System.out.println();
                main.printHelp(System.out);
                System.exit(-2);
            }
            File file = new File(main.defaultsFile);
            if (file.exists()) {
                main.parsePropertiesFile(new FileInputStream(file));
            }
            if ((list = main.checkSetup()).size() > 0) {
                main.printHelp(list, System.out);
                return;
            }
            try {
                main.applyDefaults();
                main.configureClassLoader();
                main.doMigration();
            }
            catch (Throwable throwable) {
                String string2 = throwable.getMessage();
                if (throwable.getCause() != null) {
                    string2 = throwable.getCause().getMessage();
                }
                if (string2 == null) {
                    string2 = "Unknown Reason";
                }
                if (throwable.getCause() instanceof ValidationFailedException) {
                    ((ValidationFailedException)throwable.getCause()).printDescriptiveError(System.out);
                } else {
                    System.out.println("Migration Failed: " + string2 + Main.generateLogLevelWarningMessage());
                    LogFactory.getLogger().log(Level.SEVERE, string2, throwable);
                }
                System.exit(-1);
            }
            if ("update".equals(main.command)) {
                System.out.println("Migration successful");
            } else if (main.command.startsWith("rollback") && !main.command.endsWith("SQL")) {
                System.out.println("Rollback successful");
            }
        }
        catch (Throwable throwable) {
            String string = "Unexpected error running LiquiBase: " + throwable.getMessage();
            System.out.println(string);
            LogFactory.getLogger().log(Level.SEVERE, string, throwable);
            System.exit(-3);
        }
    }

    private static String generateLogLevelWarningMessage() {
        Logger logger = LogFactory.getLogger();
        if (logger == null || logger.getLevel() == null || logger.getLevel().equals(Level.OFF)) {
            return "";
        }
        return ".  For more information, use the --logLevel flag)";
    }

    protected String[] fixupArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("--") && !string.contains("=")) {
                String string2 = null;
                if (i + 1 < stringArray.length) {
                    string2 = stringArray[i + 1];
                }
                if (string2 != null && !string2.startsWith("--") && !this.isCommand(string2)) {
                    string = string + "=" + string2;
                    ++i;
                }
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected List<String> checkSetup() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.command == null) {
            arrayList.add("Command not passed");
        } else if (!this.isCommand(this.command)) {
            arrayList.add("Unknown command: " + this.command);
        } else {
            if (this.url == null) {
                arrayList.add("--url is required");
            }
            if (this.isChangeLogRequired(this.command) && this.changeLogFile == null) {
                arrayList.add("--changeLog is required");
            }
        }
        return arrayList;
    }

    private boolean isChangeLogRequired(String string) {
        return string.toLowerCase().startsWith("update") || string.toLowerCase().startsWith("rollback") || "validate".equals(string);
    }

    private boolean isCommand(String string) {
        return "migrate".equals(string) || "migrateSQL".equalsIgnoreCase(string) || "update".equalsIgnoreCase(string) || "updateSQL".equalsIgnoreCase(string) || "updateCount".equalsIgnoreCase(string) || "updateCountSQL".equalsIgnoreCase(string) || "rollback".equalsIgnoreCase(string) || "rollbackToDate".equalsIgnoreCase(string) || "rollbackCount".equalsIgnoreCase(string) || "rollbackSQL".equalsIgnoreCase(string) || "rollbackToDateSQL".equalsIgnoreCase(string) || "rollbackCountSQL".equalsIgnoreCase(string) || "futureRollbackSQL".equalsIgnoreCase(string) || "tag".equalsIgnoreCase(string) || "listLocks".equalsIgnoreCase(string) || "dropAll".equalsIgnoreCase(string) || "releaseLocks".equalsIgnoreCase(string) || "status".equalsIgnoreCase(string) || "validate".equalsIgnoreCase(string) || "help".equalsIgnoreCase(string) || "diff".equalsIgnoreCase(string) || "diffChangeLog".equalsIgnoreCase(string) || "generateChangeLog".equalsIgnoreCase(string) || "clearCheckSums".equalsIgnoreCase(string) || "dbDoc".equalsIgnoreCase(string) || "changelogSync".equalsIgnoreCase(string) || "changelogSyncSQL".equalsIgnoreCase(string) || "markNextChangeSetRan".equalsIgnoreCase(string) || "markNextChangeSetRanSQL".equalsIgnoreCase(string);
    }

    protected void parsePropertiesFile(InputStream inputStream) throws IOException, CommandLineParsingException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            try {
                Field field;
                Object object;
                if (entry.getKey().equals("promptOnNonLocalDatabase") || (object = (field = this.getClass().getDeclaredField((String)entry.getKey())).get(this)) != null) continue;
                String string = entry.getValue().toString().trim();
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(string));
                    continue;
                }
                field.set(this, string);
            }
            catch (Exception exception) {
                throw new CommandLineParsingException("Unknown parameter: '" + entry.getKey() + "'");
            }
        }
    }

    protected void printHelp(List<String> list, PrintStream printStream) {
        printStream.println("Errors:");
        for (String string : list) {
            printStream.println("  " + string);
        }
        printStream.println();
        this.printHelp(printStream);
    }

    protected void printHelp(PrintStream printStream) {
        printStream.println("Usage: java -jar liquibase.jar [options] [command]");
        printStream.println("");
        printStream.println("Standard Commands:");
        printStream.println(" update                         Updates database to current version");
        printStream.println(" updateSQL                      Writes SQL to update database to current");
        printStream.println("                                version to STDOUT");
        printStream.println(" updateCount <num>              Applies next NUM changes to the database");
        printStream.println(" updateSQL <num>                Writes SQL to apply next NUM changes");
        printStream.println("                                to the database");
        printStream.println(" rollback <tag>                 Rolls back the database to the the state is was");
        printStream.println("                                when the tag was applied");
        printStream.println(" rollbackSQL <tag>              Writes SQL to roll back the database to that");
        printStream.println("                                state it was in when the tag was applied");
        printStream.println("                                to STDOUT");
        printStream.println(" rollbackToDate <date/time>     Rolls back the database to the the state is was");
        printStream.println("                                at the given date/time.");
        printStream.println("                                Date Format: yyyy-MM-dd HH:mm:ss");
        printStream.println(" rollbackToDateSQL <date/time>  Writes SQL to roll back the database to that");
        printStream.println("                                state it was in at the given date/time version");
        printStream.println("                                to STDOUT");
        printStream.println(" rollbackCount <value>          Rolls back the last <value> change sets");
        printStream.println("                                applied to the database");
        printStream.println(" rollbackCountSQL <value>       Writes SQL to roll back the last");
        printStream.println("                                <value> change sets to STDOUT");
        printStream.println("                                applied to the database");
        printStream.println(" futureRollbackSQL              Writes SQL to roll back the database to the ");
        printStream.println("                                current state after the changes in the ");
        printStream.println("                                changeslog have been applied");
        printStream.println(" generateChangeLog              Writes Change Log XML to copy the current state");
        printStream.println("                                of the database to standard out");
        printStream.println("");
        printStream.println("Diff Commands");
        printStream.println(" diff [diff parameters]          Writes description of differences");
        printStream.println("                                 to standard out");
        printStream.println(" diffChangeLog [diff parameters] Writes Change Log XML to update");
        printStream.println("                                 the base database");
        printStream.println("                                 to the target database to standard out");
        printStream.println("");
        printStream.println("Documentation Commands");
        printStream.println(" dbDoc <outputDirectory>         Generates Javadoc-like documentation");
        printStream.println("                                 based on current database and change log");
        printStream.println("");
        printStream.println("Maintenance Commands");
        printStream.println(" tag <tag string>          'Tags' the current database state for future rollback");
        printStream.println(" status [--verbose]        Outputs count (list if --verbose) of unrun changesets");
        printStream.println(" validate                  Checks changelog for errors");
        printStream.println(" clearCheckSums            Removes all saved checksums from database log.");
        printStream.println("                           Useful for 'MD5Sum Check Failed' errors");
        printStream.println(" changelogSync             Mark all changes as executed in the database");
        printStream.println(" changelogSyncSQL          Writes SQL to mark all changes as executed ");
        printStream.println("                           in the database to STDOUT");
        printStream.println(" markNextNextChangeLogRan  Mark the next change changes as executed ");
        printStream.println("                           in the database");
        printStream.println(" markNextNextChangeLogRanSQL Writes SQL to mark the next change ");
        printStream.println("                           as executed in the database to STDOUT");
        printStream.println(" listLocks                 Lists who currently has locks on the");
        printStream.println("                           database changelog");
        printStream.println(" releaseLocks              Releases all locks on the database changelog");
        printStream.println(" dropAll                   Drop all database objects owned by user");
        printStream.println("");
        printStream.println("Required Parameters:");
        printStream.println(" --changeLogFile=<path and filename>        Migration file");
        printStream.println(" --username=<value>                         Database username");
        printStream.println(" --password=<value>                         Database password");
        printStream.println(" --url=<value>                              Database URL");
        printStream.println("");
        printStream.println("Optional Parameters:");
        printStream.println(" --classpath=<value>                        Classpath containing");
        printStream.println("                                            migration files and JDBC Driver");
        printStream.println(" --driver=<jdbc.driver.ClassName>           Database driver class name");
        printStream.println(" --databaseClass=<database.ClassName>       custom liquibase.database.Database");
        printStream.println("                                            implementation to use");
        printStream.println(" --defaultSchemaName=<name>                 Default database schema to use");
        printStream.println(" --contexts=<value>                         ChangeSet contexts to execute");
        printStream.println(" --defaultsFile=</path/to/file.properties>  File with default option values");
        printStream.println("                                            (default: ./liquibase.properties)");
        printStream.println(" --includeSystemClasspath=<true|false>      Include the system classpath");
        printStream.println("                                            in the LiquiBase classpath");
        printStream.println("                                            (default: true)");
        printStream.println(" --promptForNonLocalDatabase=<true|false>   Prompt if non-localhost");
        printStream.println("                                            databases (default: false)");
        printStream.println(" --logLevel=<level>                         Execution log level");
        printStream.println(" --logFile=<file>                           Log file");
        printStream.println("                                            (finest, finer, fine, info,");
        printStream.println("                                            warning, severe)");
        printStream.println(" --currentDateTimeFunction=<value>          Overrides current date time function");
        printStream.println("                                            used in SQL.");
        printStream.println("                                            Useful for unsupported databases");
        printStream.println(" --help                                     Prints this message");
        printStream.println(" --version                                  Prints this version information");
        printStream.println("");
        printStream.println("Required Diff Parameters:");
        printStream.println(" --baseUsername=<value>                     Base Database username");
        printStream.println(" --basePassword=<value>                     Base Database password");
        printStream.println(" --baseUrl=<value>                          Base Database URL");
        printStream.println("");
        printStream.println("Optional Diff Parameters:");
        printStream.println(" --baseDriver=<jdbc.driver.ClassName>       Base Database driver class name");
        printStream.println("");
        printStream.println("Change Log Properties:");
        printStream.println(" -D<property.name>=<property.value>         Pass a name/value pair for");
        printStream.println("                                            substitution in the change log(s)");
        printStream.println("");
        printStream.println("Default value for parameters can be stored in a file called");
        printStream.println("'liquibase.properties' that is read from the current working directory.");
        printStream.println("");
        printStream.println("Full documentation is available at");
        printStream.println("http://www.liquibase.org/manual/command_line");
        printStream.println("");
    }

    protected void parseOptions(String[] stringArray) throws CommandLineParsingException {
        stringArray = this.fixupArgs(stringArray);
        boolean bl = false;
        for (String string : stringArray) {
            String string2;
            String string3;
            String[] stringArray2;
            if (this.isCommand(string)) {
                this.command = string;
                if (this.command.equalsIgnoreCase("migrate")) {
                    this.command = "update";
                } else if (this.command.equalsIgnoreCase("migrateSQL")) {
                    this.command = "updateSQL";
                }
                bl = true;
                continue;
            }
            if (bl) {
                if (string.startsWith("-D")) {
                    stringArray2 = this.splitArg(string);
                    string3 = stringArray2[0].replaceFirst("^-D", "");
                    string2 = stringArray2[1];
                    this.changeLogParameters.put(string3, string2);
                    continue;
                }
                this.commandParams.add(string);
                continue;
            }
            if (string.startsWith("--")) {
                stringArray2 = this.splitArg(string);
                string3 = stringArray2[0];
                string2 = stringArray2[1];
                try {
                    Field field = this.getClass().getDeclaredField(string3);
                    if (field.getType().equals(Boolean.class)) {
                        field.set(this, Boolean.valueOf(string2));
                        continue;
                    }
                    field.set(this, string2);
                    continue;
                }
                catch (Exception exception) {
                    throw new CommandLineParsingException("Unknown parameter: '" + string3 + "'");
                }
            }
            throw new CommandLineParsingException("Unexpected value " + string + ": parameters must start with a '--'");
        }
    }

    private String[] splitArg(String string) throws CommandLineParsingException {
        String[] stringArray = string.split("=");
        if (stringArray.length < 2) {
            throw new CommandLineParsingException("Could not parse '" + string + "'");
        }
        if (stringArray.length > 2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append("=");
            }
            stringArray = new String[]{stringArray[0], stringBuffer.toString().replaceFirst("=$", "")};
        }
        stringArray[0] = stringArray[0].replaceFirst("--", "");
        return stringArray;
    }

    protected void applyDefaults() {
        if (this.promptForNonLocalDatabase == null) {
            this.promptForNonLocalDatabase = Boolean.FALSE;
        }
        if (this.logLevel == null) {
            this.logLevel = "off";
        }
        if (this.includeSystemClasspath == null) {
            this.includeSystemClasspath = Boolean.TRUE;
        }
    }

    protected void configureClassLoader() throws CommandLineParsingException {
        final ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.classpath != null) {
            String[] stringArray = this.isWindows() ? this.classpath.split(";") : this.classpath.split(":");
            for (String string : stringArray) {
                File file = new File(string);
                if (!file.exists()) {
                    throw new CommandLineParsingException(file.getAbsolutePath() + " does not exist");
                }
                try {
                    if (string.endsWith(".war")) {
                        this.addWarFileClasspathEntries(file, arrayList);
                        continue;
                    }
                    if (string.endsWith(".ear")) {
                        JarFile jarFile = new JarFile(file);
                        Enumeration<JarEntry> enumeration = jarFile.entries();
                        while (enumeration.hasMoreElements()) {
                            File file2;
                            JarEntry jarEntry = enumeration.nextElement();
                            if (jarEntry.getName().toLowerCase().endsWith(".jar")) {
                                file2 = this.extract(jarFile, jarEntry);
                                arrayList.add(new URL("jar:" + file2.toURL() + "!/"));
                                file2.deleteOnExit();
                                continue;
                            }
                            if (!jarEntry.getName().toLowerCase().endsWith("war")) continue;
                            file2 = this.extract(jarFile, jarEntry);
                            this.addWarFileClasspathEntries(file2, arrayList);
                        }
                        continue;
                    }
                    arrayList.add(new File(string).toURL());
                }
                catch (Exception exception) {
                    throw new CommandLineParsingException(exception);
                }
            }
        }
        this.classLoader = this.includeSystemClasspath != false ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), Thread.currentThread().getContextClassLoader());
            }
        }) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]));
            }
        });
    }

    private void addWarFileClasspathEntries(File file, List<URL> list) throws IOException {
        URL uRL = new URL("jar:" + file.toURL() + "!/WEB-INF/classes/");
        list.add(uRL);
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().startsWith("WEB-INF/lib") || !jarEntry.getName().toLowerCase().endsWith(".jar")) continue;
            File file2 = this.extract(jarFile, jarEntry);
            list.add(new URL("jar:" + file2.toURL() + "!/"));
            file2.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extract(JarFile jarFile, JarEntry jarEntry) throws IOException {
        File file = File.createTempFile("liquibase.tmp", null);
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            while ((n = bufferedInputStream.read()) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(n);
            }
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMigration() throws Exception {
        block87: {
            if ("help".equalsIgnoreCase(this.command)) {
                this.printHelp(System.out);
                return;
            }
            try {
                if (null != this.logFile) {
                    LogFactory.setLoggingLevel(this.logLevel, this.logFile);
                } else {
                    LogFactory.setLoggingLevel(this.logLevel);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CommandLineParsingException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
            FileSystemFileOpener fileSystemFileOpener = new FileSystemFileOpener();
            CommandLineFileOpener commandLineFileOpener = new CommandLineFileOpener(this.classLoader);
            Database database = CommandLineUtils.createDatabaseObject(this.classLoader, this.url, this.username, this.password, this.driver, this.defaultSchemaName, this.databaseClass);
            try {
                CompositeFileOpener compositeFileOpener = new CompositeFileOpener(fileSystemFileOpener, commandLineFileOpener);
                if ("diff".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doDiff(database, this.createDatabaseFromCommandParams(this.commandParams));
                    return;
                }
                if ("diffChangeLog".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doDiffToChangeLog(this.changeLogFile, database, this.createDatabaseFromCommandParams(this.commandParams));
                    return;
                }
                if ("generateChangeLog".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doGenerateChangeLog(this.changeLogFile, database, this.defaultSchemaName, StringUtils.trimToNull(this.diffTypes), StringUtils.trimToNull(this.changeSetAuthor), StringUtils.trimToNull(this.changeSetContext), StringUtils.trimToNull(this.dataDir));
                    return;
                }
                Liquibase liquibase = new Liquibase(this.changeLogFile, (FileOpener)compositeFileOpener, database);
                for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                    liquibase.setChangeLogParameterValue(entry.getKey(), entry.getValue());
                }
                if ("listLocks".equalsIgnoreCase(this.command)) {
                    liquibase.reportLocks(System.out);
                    return;
                }
                if ("releaseLocks".equalsIgnoreCase(this.command)) {
                    LockHandler.getInstance(database).forceReleaseLock();
                    System.out.println("Successfully released all database change log locks for " + liquibase.getDatabase().getConnectionUsername() + "@" + liquibase.getDatabase().getConnectionURL());
                    return;
                }
                if ("tag".equalsIgnoreCase(this.command)) {
                    liquibase.tag(this.commandParams.iterator().next());
                    System.out.println("Successfully tagged " + liquibase.getDatabase().getConnectionUsername() + "@" + liquibase.getDatabase().getConnectionURL());
                    return;
                }
                if ("dropAll".equals(this.command)) {
                    liquibase.dropAll();
                    System.out.println("All objects dropped from " + liquibase.getDatabase().getConnectionUsername() + "@" + liquibase.getDatabase().getConnectionURL());
                    return;
                }
                if ("status".equalsIgnoreCase(this.command)) {
                    boolean bl = false;
                    if (this.commandParams.contains("--verbose")) {
                        bl = true;
                    }
                    liquibase.reportStatus(bl, this.contexts, this.getOutputWriter());
                    return;
                }
                if ("validate".equalsIgnoreCase(this.command)) {
                    try {
                        liquibase.validate();
                    }
                    catch (ValidationFailedException validationFailedException) {
                        validationFailedException.printDescriptiveError(System.out);
                        try {
                            database.rollback();
                            database.close();
                        }
                        catch (JDBCException jDBCException) {
                            LogFactory.getLogger().log(Level.WARNING, "problem closing connection", jDBCException);
                        }
                        return;
                    }
                    System.out.println("No validation errors found");
                    return;
                }
                if ("clearCheckSums".equalsIgnoreCase(this.command)) {
                    liquibase.clearCheckSums();
                    return;
                }
                if ("dbdoc".equalsIgnoreCase(this.command)) {
                    if (this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("dbdoc requires an output directory");
                    }
                    if (this.changeLogFile == null) {
                        throw new CommandLineParsingException("dbdoc requires a changeLog parameter");
                    }
                    liquibase.generateDocumentation(this.commandParams.iterator().next());
                    return;
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    if ("update".equalsIgnoreCase(this.command)) {
                        liquibase.update(this.contexts);
                        break block87;
                    }
                    if ("changelogSync".equalsIgnoreCase(this.command)) {
                        liquibase.changeLogSync(this.contexts);
                        break block87;
                    }
                    if ("changelogSyncSQL".equalsIgnoreCase(this.command)) {
                        liquibase.changeLogSync(this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    if ("markNextChangeSetRan".equalsIgnoreCase(this.command)) {
                        liquibase.markNextChangeSetRan(this.contexts);
                        break block87;
                    }
                    if ("markNextChangeSetRanSQL".equalsIgnoreCase(this.command)) {
                        liquibase.markNextChangeSetRan(this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    if ("updateCount".equalsIgnoreCase(this.command)) {
                        liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), this.contexts);
                        break block87;
                    }
                    if ("updateCountSQL".equalsIgnoreCase(this.command)) {
                        liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    if ("updateSQL".equalsIgnoreCase(this.command)) {
                        liquibase.update(this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    if ("rollback".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null) {
                            throw new CommandLineParsingException("rollback requires a rollback tag");
                        }
                        liquibase.rollback(this.commandParams.iterator().next(), this.contexts);
                        break block87;
                    }
                    if ("rollbackToDate".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null) {
                            throw new CommandLineParsingException("rollback requires a rollback date");
                        }
                        liquibase.rollback(simpleDateFormat.parse(this.commandParams.iterator().next()), this.contexts);
                        break block87;
                    }
                    if ("rollbackCount".equalsIgnoreCase(this.command)) {
                        liquibase.rollback(Integer.parseInt(this.commandParams.iterator().next()), this.contexts);
                        break block87;
                    }
                    if ("rollbackSQL".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null) {
                            throw new CommandLineParsingException("rollbackSQL requires a rollback tag");
                        }
                        liquibase.rollback(this.commandParams.iterator().next(), this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    if ("rollbackToDateSQL".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null) {
                            throw new CommandLineParsingException("rollbackToDateSQL requires a rollback date");
                        }
                        liquibase.rollback(simpleDateFormat.parse(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    if ("rollbackCountSQL".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null) {
                            throw new CommandLineParsingException("rollbackCountSQL requires a rollback tag");
                        }
                        liquibase.rollback(Integer.parseInt(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    if ("futureRollbackSQL".equalsIgnoreCase(this.command)) {
                        liquibase.futureRollbackSQL(this.contexts, this.getOutputWriter());
                        break block87;
                    }
                    throw new CommandLineParsingException("Unknown command: " + this.command);
                }
                catch (ParseException parseException) {
                    throw new CommandLineParsingException("Unexpected date/time format.  Use 'yyyy-MM-dd HH:mm:ss'");
                }
            }
            finally {
                try {
                    database.rollback();
                    database.close();
                }
                catch (JDBCException jDBCException) {
                    LogFactory.getLogger().log(Level.WARNING, "problem closing connection", jDBCException);
                }
            }
        }
    }

    private String getCommandParam(String string) throws CommandLineParsingException {
        for (String string2 : this.commandParams) {
            String[] stringArray = this.splitArg(string2);
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            if (!string3.equalsIgnoreCase(string)) continue;
            return string4;
        }
        return null;
    }

    private Database createDatabaseFromCommandParams(Set<String> set) throws CommandLineParsingException, JDBCException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = this.defaultSchemaName;
        for (String string6 : set) {
            String[] stringArray = this.splitArg(string6);
            String string7 = stringArray[0];
            String string8 = stringArray[1];
            if ("baseDriver".equalsIgnoreCase(string7)) {
                string = string8;
                continue;
            }
            if ("baseUrl".equalsIgnoreCase(string7)) {
                string2 = string8;
                continue;
            }
            if ("baseUsername".equalsIgnoreCase(string7)) {
                string3 = string8;
                continue;
            }
            if ("basePassword".equalsIgnoreCase(string7)) {
                string4 = string8;
                continue;
            }
            if (!"baseDefaultSchemaName".equalsIgnoreCase(string7)) continue;
            string5 = string8;
        }
        return CommandLineUtils.createDatabaseObject(this.classLoader, string2, string3, string4, string, string5, null);
    }

    private Writer getOutputWriter() {
        return new OutputStreamWriter(System.out);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows ");
    }
}

