/*
 * Decompiled with CFR 0.152.
 */
package liquibase.commandline;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.HibernateDatabase;
import liquibase.diff.Diff;
import liquibase.diff.DiffResult;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.exception.MigrationFailedException;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;

public class CommandLineUtils {
    public static Database createDatabaseObject(ClassLoader classLoader, String string, String string2, String string3, String string4, String string5, String string6) throws JDBCException {
        if (string4 == null) {
            string4 = DatabaseFactory.getInstance().findDefaultDriver(string);
        }
        try {
            Connection connection;
            Driver driver;
            if (string.startsWith("hibernate:")) {
                try {
                    return CommandLineUtils.createHibernateDatabase(classLoader, string);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    try {
                        return CommandLineUtils.createHibernateDatabase(Thread.currentThread().getContextClassLoader(), string);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError2) {
                        throw new MigrationFailedException(null, "Class " + noClassDefFoundError2.getMessage() + " not found.  Make sure all required Hibernate and JDBC libraries are in your classpath");
                    }
                }
            }
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            if (string6 != null) {
                databaseFactory.addDatabaseImplementation((Database)Class.forName(string6, true, classLoader).newInstance());
            }
            try {
                if (string4 == null) {
                    string4 = databaseFactory.findDefaultDriver(string);
                }
                if (string4 == null) {
                    throw new RuntimeException("Driver class was not specified and could not be determined from the url (" + string + ")");
                }
                driver = (Driver)Class.forName(string4, true, classLoader).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot find database driver: " + exception.getMessage());
            }
            Properties properties = new Properties();
            if (string2 != null) {
                properties.put("user", string2);
            }
            if (string3 != null) {
                properties.put("password", string3);
            }
            if ((connection = driver.connect(string, properties)) == null) {
                throw new JDBCException("Connection could not be created to " + string + " with driver " + string4.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
            }
            Database database = databaseFactory.findCorrectDatabaseImplementation(connection);
            database.setDefaultSchemaName(StringUtils.trimToNull(string5));
            return database;
        }
        catch (Exception exception) {
            throw new JDBCException(exception);
        }
    }

    private static Database createHibernateDatabase(ClassLoader classLoader, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return (Database)Class.forName(HibernateDatabase.class.getName(), true, classLoader).getConstructor(String.class).newInstance(string.substring("hibernate:".length()));
    }

    public static void doDiff(Database database, Database database2) throws JDBCException {
        Diff diff = new Diff(database, database2);
        diff.addStatusListener(new OutDiffStatusListener());
        DiffResult diffResult = diff.compare();
        System.out.println("");
        System.out.println("Diff Results:");
        diffResult.printResult(System.out);
    }

    public static void doDiffToChangeLog(String string, Database database, Database database2) throws JDBCException, IOException, ParserConfigurationException {
        Diff diff = new Diff(database, database2);
        diff.addStatusListener(new OutDiffStatusListener());
        DiffResult diffResult = diff.compare();
        if (string == null) {
            diffResult.printChangeLog(System.out, database2);
        } else {
            diffResult.printChangeLog(string, database2);
        }
    }

    public static void doGenerateChangeLog(String string, Database database, String string2, String string3, String string4, String string5, String string6) throws JDBCException, IOException, ParserConfigurationException {
        Diff diff = new Diff(database, string2);
        diff.setDiffTypes(string3);
        diff.addStatusListener(new OutDiffStatusListener());
        DiffResult diffResult = diff.compare();
        diffResult.setChangeSetAuthor(string4);
        diffResult.setChangeSetContext(string5);
        diffResult.setDataDir(string6);
        PrintStream printStream = System.out;
        if (StringUtils.trimToNull(string) != null) {
            File file = new File(string);
            printStream = new PrintStream(file);
        }
        diffResult.printChangeLog(printStream, database);
    }

    private static class OutDiffStatusListener
    implements DiffStatusListener {
        private Formatter customFormatter = new Formatter(){

            public String format(LogRecord logRecord) {
                return logRecord.getMessage() + "\n";
            }
        };
        private ArrayList<Handler> handList = new ArrayList();

        private OutDiffStatusListener() {
        }

        private void prepareHandlers() {
            if (this.handList.size() > 0) {
                return;
            }
            for (Handler handler : LogFactory.getLogger().getParent().getHandlers()) {
                this.handList.add(handler);
            }
            for (Handler handler : LogFactory.getLogger().getHandlers()) {
                this.handList.add(handler);
            }
        }

        private void setCustomFormatter() {
            Object[] objectArray = this.handList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Handler handler = (Handler)objectArray[i];
                handler.setFormatter(this.customFormatter);
            }
        }

        private void restoreSimpleFormatter() {
            Object[] objectArray = this.handList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Handler handler = (Handler)objectArray[i];
                handler.setFormatter(new SimpleFormatter());
            }
        }

        public void statusUpdate(String string) {
            this.prepareHandlers();
            this.setCustomFormatter();
            LogFactory.getLogger().info(string);
            this.restoreSimpleFormatter();
        }
    }
}

