/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.change.AbstractChange;
import liquibase.change.custom.CustomChange;
import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.CustomChangeException;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.ObjectUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomChangeWrapper
extends AbstractChange {
    private CustomChange customChange;
    private String className;
    private SortedSet<String> params = new TreeSet<String>();
    private Map<String, String> paramValues = new HashMap<String, String>();
    private ClassLoader classLoader;

    public CustomChangeWrapper() {
        super("customChange", "Custom Change");
    }

    public CustomChange getCustomChange() {
        return this.customChange;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClass(String string) throws CustomChangeException {
        this.className = string;
        try {
            try {
                this.customChange = (CustomChange)Class.forName(string, true, this.classLoader).newInstance();
            }
            catch (ClassCastException classCastException) {
                this.customChange = (CustomChange)Class.forName(string).newInstance();
            }
        }
        catch (Exception exception) {
            throw new CustomChangeException(exception);
        }
    }

    public void setParam(String string, String string2) {
        this.params.add(string);
        this.paramValues.put(string, string2);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        this.customChange.validate(database);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        SqlStatement[] sqlStatementArray;
        block5: {
            sqlStatementArray = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlChange) {
                    sqlStatementArray = ((CustomSqlChange)this.customChange).generateStatements(database);
                    break block5;
                }
                if (this.customChange instanceof CustomTaskChange) {
                    ((CustomTaskChange)this.customChange).execute(database);
                    break block5;
                }
                throw new UnsupportedChangeException(this.customChange.getClass().getName() + " does not implement " + CustomSqlChange.class.getName() + " or " + CustomTaskChange.class.getName());
            }
            catch (CustomChangeException customChangeException) {
                throw new UnsupportedChangeException(customChangeException);
            }
        }
        if (sqlStatementArray == null) {
            sqlStatementArray = new SqlStatement[]{};
        }
        return sqlStatementArray;
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        SqlStatement[] sqlStatementArray;
        block5: {
            sqlStatementArray = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlRollback) {
                    sqlStatementArray = ((CustomSqlRollback)((Object)this.customChange)).generateRollbackStatements(database);
                    break block5;
                }
                if (this.customChange instanceof CustomTaskRollback) {
                    ((CustomTaskRollback)((Object)this.customChange)).rollback(database);
                    break block5;
                }
                throw new UnsupportedChangeException("Unknown rollback type: " + this.customChange.getClass().getName());
            }
            catch (CustomChangeException customChangeException) {
                throw new UnsupportedChangeException(customChangeException);
            }
        }
        if (sqlStatementArray == null) {
            sqlStatementArray = new SqlStatement[]{};
        }
        return sqlStatementArray;
    }

    @Override
    public boolean canRollBack() {
        return this.customChange instanceof CustomSqlRollback || this.customChange instanceof CustomTaskRollback;
    }

    private void configureCustomChange() throws CustomChangeException {
        try {
            for (String string : this.params) {
                ObjectUtil.setProperty(this.customChange, string, this.paramValues.get(string));
            }
            this.customChange.setFileOpener(this.getFileOpener());
            this.customChange.setUp();
        }
        catch (Exception exception) {
            throw new CustomChangeException(exception);
        }
    }

    @Override
    public String getConfirmationMessage() {
        return this.customChange.getConfirmationMessage();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("custom");
        element.setAttribute("class", this.className);
        for (String string : this.params) {
            Element element2 = document.createElement("param");
            element2.setAttribute("name", string);
            element2.setAttribute("value", this.paramValues.get(string));
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }
}

