/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDataChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private String whereClause;

    public UpdateDataChange() {
        super("update", "Update Data");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> list) {
        this.columns = list;
    }

    @Override
    public void addColumn(ColumnConfig columnConfig) {
        this.columns.add(columnConfig);
    }

    public void removeColumn(ColumnConfig columnConfig) {
        this.columns.remove(columnConfig);
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String string) {
        this.whereClause = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            if (StringUtils.trimToNull(columnConfig.getName()) != null) continue;
            throw new InvalidChangeDefinitionException("column name is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        UpdateStatement updateStatement = new UpdateStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName());
        for (ColumnConfig columnConfig : this.columns) {
            updateStatement.addNewColumnValue(columnConfig.getName(), columnConfig.getValueObject());
        }
        updateStatement.setWhereClause(this.whereClause);
        return new SqlStatement[]{updateStatement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Data updated in " + this.getTableName();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("update");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        for (ColumnConfig columnConfig : this.getColumns()) {
            Element element2 = columnConfig.createNode(document);
            element.appendChild(element2);
        }
        if (StringUtils.trimToNull(this.getWhereClause()) != null) {
            Element element3 = document.createElement("where");
            element3.appendChild(document.createTextNode(this.getWhereClause()));
            element.appendChild(element3);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table table = new Table(this.getTableName());
        return new HashSet<DatabaseObject>(Arrays.asList(table));
    }
}

