/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.TagDatabaseStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagDatabaseChange
extends AbstractChange {
    private String tag;

    public TagDatabaseChange() {
        super("tagDatabase", "Tag Database");
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tag) == null) {
            throw new InvalidChangeDefinitionException("tag is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        return new SqlStatement[]{new TagDatabaseStatement(this.tag)};
    }

    @Override
    public String getConfirmationMessage() {
        return "Tag '" + this.tag + "' applied to database";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        element.setAttribute("tag", this.getTag());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }

    @Override
    protected Change[] createInverses() {
        return new Change[0];
    }
}

