/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Logger;
import liquibase.FileOpener;
import liquibase.change.AbstractSQLChange;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.SetupException;
import liquibase.log.LogFactory;
import liquibase.util.MD5Util;
import liquibase.util.StreamUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLFileChange
extends AbstractSQLChange {
    private static final Logger log = LogFactory.getLogger();
    private String file;
    private String encoding = null;

    public SQLFileChange() {
        super("sqlFile", "SQL From File");
    }

    public String getPath() {
        return this.file;
    }

    public void setPath(String string) {
        this.file = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public void setUp() throws SetupException {
        if (this.file == null) {
            throw new SetupException("<sqlfile> - No path specified");
        }
        log.fine("SQLFile file:" + this.file);
        boolean bl = this.loadFromClasspath(this.file);
        if (!bl) {
            bl = this.loadFromFileSystem(this.file);
        }
        if (!bl) {
            throw new SetupException("<sqlfile path=" + this.file + "> - Could not find file");
        }
        log.finer("SQLFile file contents is:" + this.getSql());
    }

    private boolean loadFromFileSystem(String string) throws SetupException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.setSql(StreamUtil.getStreamContents(fileInputStream, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new SetupException("<sqlfile path=" + string + "> -Unable to read file", iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromClasspath(String string) throws SetupException {
        InputStream inputStream = null;
        try {
            FileOpener fileOpener = this.getFileOpener();
            if (fileOpener == null) {
                boolean bl = false;
                return bl;
            }
            inputStream = fileOpener.getResourceAsStream(string);
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            this.setSql(StreamUtil.getStreamContents(inputStream, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            throw new SetupException("<sqlfile path=" + string + "> -Unable to read file", iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getMD5Sum() {
        return MD5Util.computeMD5(this.getSql());
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("sqlFile");
        element.setAttribute("path", this.file);
        if (this.encoding != null) {
            element.setAttribute("encoding", this.encoding);
        }
        return element;
    }

    @Override
    public String getConfirmationMessage() {
        return "SQL in file " + this.file + " executed";
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }
}

