/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.sql.RenameTableStatement;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameTableChange
extends AbstractChange {
    private String schemaName;
    private String oldTableName;
    private String newTableName;

    public RenameTableChange() {
        super("renameTable", "Rename Table");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getOldTableName() {
        return this.oldTableName;
    }

    public void setOldTableName(String string) {
        this.oldTableName = string;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String string) {
        this.newTableName = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.oldTableName) == null) {
            throw new InvalidChangeDefinitionException("oldTableName is required", this);
        }
        if (StringUtils.trimToNull(this.newTableName) == null) {
            throw new InvalidChangeDefinitionException("newTableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        String string = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        arrayList.add(new RenameTableStatement(string, this.getOldTableName(), this.getNewTableName()));
        if (database instanceof DB2Database) {
            arrayList.add(new ReorganizeTableStatement(string, this.getNewTableName()));
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    protected Change[] createInverses() {
        RenameTableChange renameTableChange = new RenameTableChange();
        renameTableChange.setSchemaName(this.getSchemaName());
        renameTableChange.setOldTableName(this.getNewTableName());
        renameTableChange.setNewTableName(this.getOldTableName());
        return new Change[]{renameTableChange};
    }

    @Override
    public String getConfirmationMessage() {
        return "Table " + this.oldTableName + " renamed to " + this.newTableName;
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("renameTable");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("oldTableName", this.getOldTableName());
        element.setAttribute("newTableName", this.getNewTableName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table table = new Table(this.getOldTableName());
        Table table2 = new Table(this.getNewTableName());
        return new HashSet<DatabaseObject>(Arrays.asList(table, table2));
    }
}

