/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.RenameColumnStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameColumnChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String oldColumnName;
    private String newColumnName;
    private String columnDataType;

    public RenameColumnChange() {
        super("renameColumn", "Rename Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getOldColumnName() {
        return this.oldColumnName;
    }

    public void setOldColumnName(String string) {
        this.oldColumnName = string;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String string) {
        this.newColumnName = string;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String string) {
        this.columnDataType = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.oldColumnName) == null) {
            throw new InvalidChangeDefinitionException("oldColumnName is required", this);
        }
        if (StringUtils.trimToNull(this.newColumnName) == null) {
            throw new InvalidChangeDefinitionException("newColumnName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{new RenameColumnStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.getOldColumnName(), this.getNewColumnName(), this.getColumnDataType())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig columnConfig) {
                if (columnConfig.getName().equals(RenameColumnChange.this.getOldColumnName())) {
                    columnConfig.setName(RenameColumnChange.this.getNewColumnName());
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                if (index.getColumns().contains(RenameColumnChange.this.getOldColumnName())) {
                    index.getColumns().remove(RenameColumnChange.this.getOldColumnName());
                    index.getColumns().add(RenameColumnChange.this.getNewColumnName());
                }
                return true;
            }
        };
        try {
            arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException jDBCException) {
            this.log.log(Level.WARNING, "unable to rename column", jDBCException);
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    protected Change[] createInverses() {
        RenameColumnChange renameColumnChange = new RenameColumnChange();
        renameColumnChange.setSchemaName(this.getSchemaName());
        renameColumnChange.setTableName(this.getTableName());
        renameColumnChange.setOldColumnName(this.getNewColumnName());
        renameColumnChange.setNewColumnName(this.getOldColumnName());
        renameColumnChange.setColumnDataType(this.getColumnDataType());
        return new Change[]{renameColumnChange};
    }

    @Override
    public String getConfirmationMessage() {
        return "Column " + this.tableName + "." + this.oldColumnName + " renamed to " + this.newColumnName;
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("renameColumn");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("oldColumnName", this.getOldColumnName());
        element.setAttribute("newColumnName", this.getNewColumnName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table table = new Table(this.getTableName());
        Column column = new Column();
        column.setTable(table);
        column.setName(this.getOldColumnName());
        Column column2 = new Column();
        column2.setTable(table);
        column2.setName(this.getNewColumnName());
        return new HashSet<Comparable>(Arrays.asList(table, column, column2));
    }
}

