/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyColumnChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public ModifyColumnChange() {
        super("modifyColumn", "Modify Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void addColumn(ColumnConfig columnConfig) {
        this.columns.add(columnConfig);
    }

    public void removeColumn(ColumnConfig columnConfig) {
        this.columns.remove(columnConfig);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig columnConfig : this.columns) {
            if (StringUtils.trimToNull(columnConfig.getName()) != null) continue;
            throw new InvalidChangeDefinitionException("column name is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        for (ColumnConfig columnConfig : this.columns) {
            String string;
            String string2 = string = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
            if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " MODIFY " + columnConfig.getName() + " " + database.getColumnType(columnConfig.getType(), false)));
                continue;
            }
            if (database instanceof MSSQLDatabase) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " ALTER COLUMN " + columnConfig.getName() + " " + database.getColumnType(columnConfig.getType(), false)));
                continue;
            }
            if (database instanceof MySQLDatabase) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " MODIFY COLUMN " + columnConfig.getName() + " " + database.getColumnType(columnConfig.getType(), false)));
                continue;
            }
            if (database instanceof OracleDatabase || database instanceof MaxDBDatabase) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " MODIFY (" + columnConfig.getName() + " " + database.getColumnType(columnConfig.getType(), false) + ")"));
                continue;
            }
            if (database instanceof DerbyDatabase) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " ALTER COLUMN " + columnConfig.getName() + " SET DATA TYPE " + database.getColumnType(columnConfig.getType(), false)));
                continue;
            }
            if (database instanceof HsqlDatabase) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " ALTER COLUMN " + columnConfig.getName() + " " + database.getColumnType(columnConfig.getType(), false)));
                continue;
            }
            if (database instanceof CacheDatabase) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " ALTER COLUMN " + columnConfig.getName() + " " + database.getColumnType(columnConfig.getType(), false)));
                continue;
            }
            if (database instanceof DB2Database) {
                arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " ALTER COLUMN " + columnConfig.getName() + " SET DATA TYPE " + database.getColumnType(columnConfig.getType(), false)));
                arrayList.add(new ReorganizeTableStatement(string, this.getTableName()));
                continue;
            }
            arrayList.add(new RawSqlStatement("ALTER TABLE " + database.escapeTableName(string, this.getTableName()) + " ALTER COLUMN " + columnConfig.getName() + " TYPE " + database.getColumnType(columnConfig.getType(), false)));
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig columnConfig) {
                for (ColumnConfig columnConfig2 : ModifyColumnChange.this.columns) {
                    if (!columnConfig2.getName().equals(columnConfig.getName())) continue;
                    columnConfig.setType(columnConfig2.getType());
                    break;
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException jDBCException) {
            this.log.log(Level.WARNING, "unable to modify column", jDBCException);
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        ArrayList<String> arrayList = new ArrayList<String>(this.columns.size());
        for (ColumnConfig columnConfig : this.columns) {
            arrayList.add(columnConfig.getName() + "(" + columnConfig.getType() + ")");
        }
        return "Columns " + StringUtils.join(arrayList, ",") + " of " + this.getTableName() + " modified";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("modifyColumn");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        for (ColumnConfig columnConfig : this.getColumns()) {
            Element element2 = columnConfig.createNode(document);
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        ArrayList<Column> arrayList = new ArrayList<Column>(this.columns.size());
        Table table = new Table(this.getTableName());
        for (ColumnConfig columnConfig : this.columns) {
            Column column = new Column();
            column.setTable(table);
            column.setName(columnConfig.getName());
            arrayList.add(column);
        }
        return new HashSet<DatabaseObject>(arrayList);
    }
}

