/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnChange;
import liquibase.change.ColumnConfig;
import liquibase.change.DropColumnChange;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeColumnChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String column1Name;
    private String joinString;
    private String column2Name;
    private String finalColumnName;
    private String finalColumnType;

    public MergeColumnChange() {
        super("mergeColumns", "Merge Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getColumn1Name() {
        return this.column1Name;
    }

    public void setColumn1Name(String string) {
        this.column1Name = string;
    }

    public String getJoinString() {
        return this.joinString;
    }

    public void setJoinString(String string) {
        this.joinString = string;
    }

    public String getColumn2Name() {
        return this.column2Name;
    }

    public void setColumn2Name(String string) {
        this.column2Name = string;
    }

    public String getFinalColumnName() {
        return this.finalColumnName;
    }

    public void setFinalColumnName(String string) {
        this.finalColumnName = string;
    }

    public String getFinalColumnType() {
        return this.finalColumnType;
    }

    public void setFinalColumnType(String string) {
        this.finalColumnType = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.column1Name) == null) {
            throw new InvalidChangeDefinitionException("column1Name is required", this);
        }
        if (StringUtils.trimToNull(this.column2Name) == null) {
            throw new InvalidChangeDefinitionException("column2Name is required", this);
        }
        if (StringUtils.trimToNull(this.finalColumnName) == null) {
            throw new InvalidChangeDefinitionException("finalColumnName is required", this);
        }
        if (StringUtils.trimToNull(this.finalColumnType) == null) {
            throw new InvalidChangeDefinitionException("finalColumnType is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        AddColumnChange addColumnChange = new AddColumnChange();
        String string = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        addColumnChange.setSchemaName(string);
        addColumnChange.setTableName(this.getTableName());
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(this.getFinalColumnName());
        columnConfig.setType(this.getFinalColumnType());
        addColumnChange.addColumn(columnConfig);
        arrayList.addAll(Arrays.asList(addColumnChange.generateStatements(database)));
        String string2 = "UPDATE " + database.escapeTableName(string, this.getTableName()) + " SET " + this.getFinalColumnName() + " = " + database.getConcatSql(this.getColumn1Name(), "'" + this.getJoinString() + "'", this.getColumn2Name());
        arrayList.add(new RawSqlStatement(string2));
        if (database instanceof SQLiteDatabase) {
            SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

                public ColumnConfig[] getColumnsToAdd() {
                    ColumnConfig[] columnConfigArray = new ColumnConfig[1];
                    ColumnConfig columnConfig = new ColumnConfig();
                    columnConfig.setName(MergeColumnChange.this.getFinalColumnName());
                    columnConfig.setType(MergeColumnChange.this.getFinalColumnType());
                    columnConfigArray[0] = new ColumnConfig(columnConfig);
                    return columnConfigArray;
                }

                public boolean copyThisColumn(ColumnConfig columnConfig) {
                    return !columnConfig.getName().equals(MergeColumnChange.this.getColumn1Name()) && !columnConfig.getName().equals(MergeColumnChange.this.getColumn2Name());
                }

                public boolean createThisColumn(ColumnConfig columnConfig) {
                    return !columnConfig.getName().equals(MergeColumnChange.this.getColumn1Name()) && !columnConfig.getName().equals(MergeColumnChange.this.getColumn2Name());
                }

                public boolean createThisIndex(Index index) {
                    return !index.getColumns().contains(MergeColumnChange.this.getColumn1Name()) && !index.getColumns().contains(MergeColumnChange.this.getColumn2Name());
                }
            };
            try {
                arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
            }
            catch (JDBCException jDBCException) {
                jDBCException.printStackTrace();
            }
        } else {
            DropColumnChange dropColumnChange = new DropColumnChange();
            dropColumnChange.setSchemaName(string);
            dropColumnChange.setTableName(this.getTableName());
            dropColumnChange.setColumnName(this.getColumn1Name());
            arrayList.addAll(Arrays.asList(dropColumnChange.generateStatements(database)));
            DropColumnChange dropColumnChange2 = new DropColumnChange();
            dropColumnChange2.setSchemaName(string);
            dropColumnChange2.setTableName(this.getTableName());
            dropColumnChange2.setColumnName(this.getColumn2Name());
            arrayList.addAll(Arrays.asList(dropColumnChange2.generateStatements(database)));
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    public SqlStatement[] generateStatements(DerbyDatabase derbyDatabase) throws UnsupportedChangeException {
        throw new UnsupportedChangeException("Derby does not currently support merging columns");
    }

    @Override
    public String getConfirmationMessage() {
        return "Columns " + this.getTableName() + "." + this.getColumn1Name() + " and " + this.getTableName() + "." + this.getColumn2Name() + " merged";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("column1Name", this.getColumn1Name());
        element.setAttribute("joinString", this.getJoinString());
        element.setAttribute("column2Name", this.getColumn2Name());
        element.setAttribute("finalColumnName", this.getFinalColumnName());
        element.setAttribute("finalColumnType", this.getFinalColumnType());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> hashSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getTableName());
        hashSet.add(table);
        Column column = new Column();
        column.setTable(table);
        column.setName(this.column1Name);
        hashSet.add(column);
        Column column2 = new Column();
        column2.setTable(table);
        column2.setName(this.column2Name);
        hashSet.add(column2);
        return hashSet;
    }
}

