/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.LoadDataColumnConfig;
import liquibase.csv.CSVReader;
import liquibase.database.Database;
import liquibase.database.sql.InsertStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.MD5Util;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadDataChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private String file;
    private String encoding = null;
    private List<LoadDataColumnConfig> columns = new ArrayList<LoadDataColumnConfig>();

    public LoadDataChange() {
        super("loadData", "Load Data");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public void addColumn(ColumnConfig columnConfig) {
        this.columns.add((LoadDataColumnConfig)columnConfig);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        try {
            InputStream inputStream = this.getFileOpener().getResourceAsStream(this.getFile());
            if (inputStream == null) {
                throw new UnsupportedChangeException("Data file " + this.getFile() + " was not found");
            }
            InputStreamReader inputStreamReader = this.getEncoding() == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.getEncoding());
            CSVReader cSVReader = new CSVReader(inputStreamReader);
            String[] stringArray = cSVReader.readNext();
            if (stringArray == null) {
                throw new UnsupportedChangeException("Data file " + this.getFile() + " was empty");
            }
            ArrayList<InsertStatement> arrayList = new ArrayList<InsertStatement>();
            String[] stringArray2 = null;
            while ((stringArray2 = cSVReader.readNext()) != null) {
                InsertStatement insertStatement = new InsertStatement(this.getSchemaName(), this.getTableName());
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = null;
                    Object object = stringArray2[i];
                    ColumnConfig columnConfig = this.getColumnConfig(i, stringArray[i]);
                    if (columnConfig != null) {
                        string = columnConfig.getName();
                        if (object.toString().equalsIgnoreCase("NULL")) {
                            object = "NULL";
                        } else if (columnConfig.getType() != null) {
                            ColumnConfig columnConfig2 = new ColumnConfig();
                            if (columnConfig.getType().equalsIgnoreCase("BOOLEAN")) {
                                columnConfig2.setValueBoolean(Boolean.parseBoolean(object.toString().toLowerCase()));
                            } else if (columnConfig.getType().equalsIgnoreCase("NUMERIC")) {
                                columnConfig2.setValueNumeric(object.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("DATE")) {
                                columnConfig2.setValueDate(object.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("STRING")) {
                                columnConfig2.setValue(object.toString());
                            } else {
                                throw new UnsupportedChangeException("loadData type of " + columnConfig.getType() + " is not supported.  Please use BOOLEAN, NUMERIC, DATE, or STRING");
                            }
                            object = columnConfig2.getValueObject();
                        }
                    }
                    if (string == null) {
                        string = stringArray[i];
                    }
                    insertStatement.addColumnValue(string, object);
                }
                arrayList.add(insertStatement);
            }
            return arrayList.toArray(new SqlStatement[arrayList.size()]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private ColumnConfig getColumnConfig(int n, String string) {
        for (LoadDataColumnConfig loadDataColumnConfig : this.columns) {
            if (loadDataColumnConfig.getIndex() != null && loadDataColumnConfig.getIndex().equals(n)) {
                return loadDataColumnConfig;
            }
            if (loadDataColumnConfig.getHeader() == null || !loadDataColumnConfig.getHeader().equals(string)) continue;
            return loadDataColumnConfig;
        }
        return null;
    }

    @Override
    public String getConfirmationMessage() {
        return "Data loaded from " + this.getFile() + " into " + this.getTableName();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("loadData");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("file", this.getFile());
        element.setAttribute("tableName", this.getTableName());
        if (this.getEncoding() != null) {
            element.setAttribute("encoding", this.getEncoding());
        }
        for (LoadDataColumnConfig loadDataColumnConfig : this.columns) {
            element.appendChild(loadDataColumnConfig.createNode(document));
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }

    @Override
    public String getMD5Sum() {
        InputStream inputStream = null;
        try {
            inputStream = this.getFileOpener().getResourceAsStream(this.getFile());
            if (inputStream == null) {
                throw new RuntimeException(this.getFile() + " could not be found");
            }
            String string = MD5Util.computeMD5(inputStream);
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

