/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.log.LogFactory;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteShellCommandChange
extends AbstractChange {
    private String executable;
    private List<String> os;
    private List<String> args = new ArrayList<String>();

    public ExecuteShellCommandChange() {
        super("executeCommand", "Execute Shell Command");
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String string) {
        this.executable = string;
    }

    public void addArg(String string) {
        this.args.add(string);
    }

    public void setOs(String string) {
        this.os = StringUtils.splitAndTrim(string, ",");
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.executable) == null) {
            throw new InvalidChangeDefinitionException("executable is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        Object object;
        boolean bl = true;
        if (this.os != null && this.os.size() > 0 && !this.os.contains(object = System.getProperty("os.name"))) {
            bl = false;
            LogFactory.getLogger().info("Not executing on os " + (String)object + " when " + this.os + " was specified");
        }
        if (bl) {
            object = new ArrayList();
            object.add(this.executable);
            object.addAll(this.args);
            try {
                ProcessBuilder processBuilder = new ProcessBuilder((List<String>)object);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                int n = 0;
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                StreamUtil.copy(process.getErrorStream(), byteArrayOutputStream);
                StreamUtil.copy(process.getInputStream(), byteArrayOutputStream2);
                LogFactory.getLogger().info(byteArrayOutputStream.toString());
                LogFactory.getLogger().info(byteArrayOutputStream2.toString());
                if (n != 0) {
                    throw new RuntimeException(this.getCommandString() + " returned an code of " + n);
                }
            }
            catch (IOException iOException) {
                throw new UnsupportedChangeException("Error executing command: " + iOException);
            }
        }
        return new SqlStatement[0];
    }

    @Override
    public String getConfirmationMessage() {
        return "Shell command '" + this.getCommandString() + "' executed";
    }

    private String getCommandString() {
        return this.executable + " " + StringUtils.join(this.args, " ");
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        element.setAttribute("executable", this.getExecutable());
        for (String string : this.args) {
            Element element2 = document.createElement("arg");
            element2.setAttribute("value", string);
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }
}

