/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.DropTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropTableChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private Boolean cascadeConstraints;

    public DropTableChange() {
        super("dropTable", "Drop Table");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public Boolean isCascadeConstraints() {
        return this.cascadeConstraints;
    }

    public void setCascadeConstraints(Boolean bl) {
        this.cascadeConstraints = bl;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        boolean bl = false;
        if (this.isCascadeConstraints() != null) {
            bl = this.isCascadeConstraints();
        }
        return new SqlStatement[]{new DropTableStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), bl)};
    }

    @Override
    public String getConfirmationMessage() {
        return "Table " + this.getTableName() + " dropped";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("dropTable");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        if (this.isCascadeConstraints() != null) {
            element.setAttribute("cascadeConstraints", this.isCascadeConstraints().toString());
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table table = new Table(this.getTableName());
        return new HashSet<DatabaseObject>(Arrays.asList(table));
    }
}

