/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.DropForeignKeyConstraintStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropForeignKeyConstraintChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private String constraintName;

    public DropForeignKeyConstraintChange() {
        super("dropForeignKeyConstraint", "Drop Foreign Key Constraint");
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String string) {
        this.baseTableSchemaName = string;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String string) {
        this.baseTableName = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.baseTableName) == null) {
            throw new InvalidChangeDefinitionException("baseTableName is required", this);
        }
        if (StringUtils.trimToNull(this.constraintName) == null) {
            throw new InvalidChangeDefinitionException("constraintName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{new DropForeignKeyConstraintStatement(this.getBaseTableSchemaName() == null ? database.getDefaultSchemaName() : this.getBaseTableSchemaName(), this.getBaseTableName(), this.getConstraintName())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        return new SqlStatement[0];
    }

    @Override
    public String getConfirmationMessage() {
        return "Foreign key " + this.getConstraintName() + " dropped";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getBaseTableSchemaName() != null) {
            element.setAttribute("baseTableSchemaName", this.getBaseTableSchemaName());
        }
        element.setAttribute("baseTableName", this.getBaseTableName());
        element.setAttribute("constraintName", this.getConstraintName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> hashSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getBaseTableName());
        hashSet.add(table);
        ForeignKey foreignKey = new ForeignKey();
        foreignKey.setName(this.constraintName);
        foreignKey.setForeignKeyTable(table);
        hashSet.add(foreignKey);
        return hashSet;
    }
}

