/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.DropDefaultValueStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropDefaultValueChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;

    public DropDefaultValueChange() {
        super("dropDefaultValue", "Drop Default Value");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.columnName) == null) {
            throw new InvalidChangeDefinitionException("columnName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{new DropDefaultValueStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.getColumnName())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig columnConfig) {
                if (columnConfig.getName().equals(DropDefaultValueChange.this.getColumnName())) {
                    columnConfig.setDefaultValue(null);
                    columnConfig.setDefaultValueBoolean(null);
                    columnConfig.setDefaultValueDate((Date)null);
                    columnConfig.setDefaultValueNumeric((Number)null);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException jDBCException) {
            jDBCException.printStackTrace();
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return "Default value dropped from " + this.getTableName() + "." + this.getColumnName();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("columnName", this.getColumnName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Column column = new Column();
        Table table = new Table(this.getTableName());
        column.setTable(table);
        column.setName(this.columnName);
        return new HashSet<Comparable>(Arrays.asList(table, column));
    }
}

