/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.database.sql.FindForeignKeyConstraintsStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.template.JdbcTemplate;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropAllForeignKeyConstraintsChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private List<DropForeignKeyConstraintChange> childDropChanges;

    public DropAllForeignKeyConstraintsChange() {
        super("dropAllForeignKeyConstraints", "Drop All Foreign Key Constraints");
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String string) {
        this.baseTableSchemaName = string;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String string) {
        this.baseTableName = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.baseTableName) == null) {
            throw new InvalidChangeDefinitionException("baseTableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        if (this.childDropChanges == null) {
            this.generateChildren(database);
        }
        if (this.childDropChanges != null) {
            for (DropForeignKeyConstraintChange dropForeignKeyConstraintChange : this.childDropChanges) {
                arrayList.addAll(Arrays.asList(dropForeignKeyConstraintChange.generateStatements(database)));
            }
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return "Foreign keys on base table " + this.getBaseTableName() + " dropped";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getBaseTableSchemaName() != null) {
            element.setAttribute("baseTableSchemaName", this.getBaseTableSchemaName());
        }
        element.setAttribute("baseTableName", this.getBaseTableName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> hashSet = null;
        if (this.childDropChanges != null) {
            hashSet = new HashSet<DatabaseObject>();
            for (DropForeignKeyConstraintChange dropForeignKeyConstraintChange : this.childDropChanges) {
                hashSet.addAll(dropForeignKeyConstraintChange.getAffectedDatabaseObjects());
            }
        }
        return hashSet;
    }

    private void generateChildren(Database database) throws UnsupportedChangeException {
        this.childDropChanges = new ArrayList<DropForeignKeyConstraintChange>();
        JdbcTemplate jdbcTemplate = database.getJdbcTemplate();
        FindForeignKeyConstraintsStatement findForeignKeyConstraintsStatement = new FindForeignKeyConstraintsStatement(this.getBaseTableSchemaName(), this.getBaseTableName());
        try {
            List<Map> list = jdbcTemplate.queryForList((SqlStatement)findForeignKeyConstraintsStatement, new ArrayList<SqlVisitor>());
            if (list != null && list.size() > 0) {
                for (Map map : list) {
                    String string = (String)map.get("k_table");
                    String string2 = (String)map.get("constraint_name");
                    if (this.getBaseTableName().equals(string)) {
                        DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
                        dropForeignKeyConstraintChange.setBaseTableSchemaName(this.getBaseTableSchemaName());
                        dropForeignKeyConstraintChange.setBaseTableName(string);
                        dropForeignKeyConstraintChange.setConstraintName(string2);
                        this.childDropChanges.add(dropForeignKeyConstraintChange);
                        continue;
                    }
                    throw new IllegalStateException("Expected to return only foreign keys for base table name: " + this.getBaseTableName() + " and got results for table: " + string);
                }
            }
        }
        catch (JDBCException jDBCException) {
            throw new UnsupportedChangeException("Failed to find foreign keys for table: " + this.getBaseTableName(), jDBCException);
        }
    }
}

