/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.DeleteStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDataChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String whereClause;

    public DeleteDataChange() {
        super("delete", "Delete Data");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String string) {
        this.whereClause = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        DeleteStatement deleteStatement = new DeleteStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName());
        deleteStatement.setWhereClause(this.whereClause);
        return new SqlStatement[]{deleteStatement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Data deleted from " + this.getTableName();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("delete");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        if (StringUtils.trimToNull(this.getWhereClause()) != null) {
            Element element2 = document.createElement("where");
            element2.appendChild(document.createTextNode(this.getWhereClause()));
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table table = new Table(this.getTableName());
        return new HashSet<DatabaseObject>(Arrays.asList(table));
    }
}

