/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DropViewChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.CreateViewStatement;
import liquibase.database.sql.DropViewStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.View;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateViewChange
extends AbstractChange {
    private String schemaName;
    private String viewName;
    private String selectQuery;
    private Boolean replaceIfExists;

    public CreateViewChange() {
        super("createView", "Create View");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public void setSelectQuery(String string) {
        this.selectQuery = string;
    }

    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public void setReplaceIfExists(Boolean bl) {
        this.replaceIfExists = bl;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.viewName) == null) {
            throw new InvalidChangeDefinitionException("viewName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        boolean bl = false;
        if (this.getReplaceIfExists() != null && this.getReplaceIfExists().booleanValue()) {
            bl = true;
        }
        if (!this.supportsReplaceIfExistsOption(database) && bl) {
            arrayList.add(new DropViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName()));
            arrayList.add(new CreateViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName(), this.getSelectQuery(), false));
        } else {
            arrayList.add(new CreateViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName(), this.getSelectQuery(), bl));
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return "View " + this.getViewName() + " created";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("createView");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("viewName", this.getViewName());
        element.appendChild(document.createCDATASection(this.getSelectQuery()));
        return element;
    }

    @Override
    protected Change[] createInverses() {
        DropViewChange dropViewChange = new DropViewChange();
        dropViewChange.setViewName(this.getViewName());
        return new Change[]{dropViewChange};
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        View view = new View();
        view.setName(this.viewName);
        return new HashSet<DatabaseObject>(Arrays.asList(view));
    }

    private boolean supportsReplaceIfExistsOption(Database database) {
        return !(database instanceof SQLiteDatabase);
    }
}

