/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DropTableChange;
import liquibase.database.Database;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.CreateTableStatement;
import liquibase.database.sql.ForeignKeyConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.SetColumnRemarksStatement;
import liquibase.database.sql.SetTableRemarksStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UniqueConstraint;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableChange
extends AbstractChange
implements ChangeWithColumns {
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String remarks;

    public CreateTableChange() {
        super("createTable", "Create Table");
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (this.getColumns().size() == 0) {
            throw new InvalidChangeDefinitionException("No columns defined", this);
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            if (StringUtils.trimToNull(columnConfig.getName()) == null) {
                throw new InvalidChangeDefinitionException("Column name is required", this);
            }
            if (StringUtils.trimToNull(columnConfig.getType()) != null) continue;
            throw new InvalidChangeDefinitionException("Column type is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        SetTableRemarksStatement setTableRemarksStatement;
        Object object;
        String string = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        CreateTableStatement createTableStatement = new CreateTableStatement(string, this.getTableName());
        for (ColumnConfig object22 : this.getColumns()) {
            ConstraintsConfig constraintsConfig = object22.getConstraints();
            boolean bl = object22.isAutoIncrement() != null && object22.isAutoIncrement() != false;
            object = null;
            if (object22.hasDefaultValue()) {
                object = StringUtils.trimToNull(object22.getDefaultColumnValue(database));
            }
            if (constraintsConfig != null && constraintsConfig.isPrimaryKey() != null && constraintsConfig.isPrimaryKey().booleanValue()) {
                createTableStatement.addPrimaryKeyColumn(object22.getName(), database.getColumnType(object22.getType(), bl), (String)object, constraintsConfig.getPrimaryKeyName(), new ColumnConstraint[0]);
            } else {
                createTableStatement.addColumn(object22.getName(), database.getColumnType(object22.getType(), object22.isAutoIncrement()), (String)object);
            }
            if (constraintsConfig != null) {
                if (constraintsConfig.isNullable() != null && !constraintsConfig.isNullable().booleanValue()) {
                    createTableStatement.addColumnConstraint(new NotNullConstraint(object22.getName()));
                }
                if (constraintsConfig.getReferences() != null) {
                    if (StringUtils.trimToNull(constraintsConfig.getForeignKeyName()) == null) {
                        throw new UnsupportedChangeException("createTable with references requires foreignKeyName");
                    }
                    ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint(constraintsConfig.getForeignKeyName(), constraintsConfig.getReferences());
                    foreignKeyConstraint.setColumn(object22.getName());
                    foreignKeyConstraint.setDeleteCascade(constraintsConfig.isDeleteCascade() != null && constraintsConfig.isDeleteCascade() != false);
                    foreignKeyConstraint.setInitiallyDeferred(constraintsConfig.isInitiallyDeferred() != null && constraintsConfig.isInitiallyDeferred() != false);
                    foreignKeyConstraint.setDeferrable(constraintsConfig.isDeferrable() != null && constraintsConfig.isDeferrable() != false);
                    createTableStatement.addColumnConstraint(foreignKeyConstraint);
                }
                if (constraintsConfig.isUnique() != null && constraintsConfig.isUnique().booleanValue()) {
                    createTableStatement.addColumnConstraint(new UniqueConstraint(constraintsConfig.getUniqueConstraintName()).addColumns(object22.getName()));
                }
            }
            if (!bl) continue;
            createTableStatement.addColumnConstraint(new AutoIncrementConstraint(object22.getName()));
        }
        createTableStatement.setTablespace(StringUtils.trimToNull(this.getTablespace()));
        ArrayList arrayList = new ArrayList();
        arrayList.add(createTableStatement);
        if (StringUtils.trimToNull(this.remarks) != null && (setTableRemarksStatement = new SetTableRemarksStatement(string, this.tableName, this.remarks)).supportsDatabase(database)) {
            arrayList.add(setTableRemarksStatement);
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            String string2 = StringUtils.trimToNull(columnConfig.getRemarks());
            if (string2 == null || !((SetColumnRemarksStatement)(object = new SetColumnRemarksStatement(string, this.tableName, columnConfig.getName(), string2))).supportsDatabase(database)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropTableChange dropTableChange = new DropTableChange();
        dropTableChange.setSchemaName(this.getSchemaName());
        dropTableChange.setTableName(this.getTableName());
        return new Change[]{dropTableChange};
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String string) {
        this.tablespace = string;
    }

    @Override
    public void addColumn(ColumnConfig columnConfig) {
        this.columns.add(columnConfig);
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Table " + this.tableName + " created";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("createTable");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        if (StringUtils.trimToNull(this.tablespace) != null) {
            element.setAttribute("tablespace", this.tablespace);
        }
        if (StringUtils.trimToNull(this.remarks) != null) {
            element.setAttribute("remarks", this.remarks);
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            element.appendChild(columnConfig.createNode(document));
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> hashSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getTableName());
        hashSet.add(table);
        for (ColumnConfig columnConfig : this.getColumns()) {
            Column column = new Column();
            column.setTable(table);
            column.setName(columnConfig.getName());
            hashSet.add(column);
        }
        return hashSet;
    }
}

