/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DropSequenceChange;
import liquibase.database.Database;
import liquibase.database.sql.CreateSequenceStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Sequence;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSequenceChange
extends AbstractChange {
    private String schemaName;
    private String sequenceName;
    private Integer startValue;
    private Integer incrementBy;
    private Integer maxValue;
    private Integer minValue;
    private Boolean ordered;

    public CreateSequenceChange() {
        super("createSequence", "Create Sequence");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public Integer getStartValue() {
        return this.startValue;
    }

    public void setStartValue(Integer n) {
        this.startValue = n;
    }

    public Integer getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(Integer n) {
        this.incrementBy = n;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer n) {
        this.maxValue = n;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer n) {
        this.minValue = n;
    }

    public Boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(Boolean bl) {
        this.ordered = bl;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.sequenceName) == null) {
            throw new InvalidChangeDefinitionException("sequenceName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        return new SqlStatement[]{new CreateSequenceStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getSequenceName()).setIncrementBy(this.getIncrementBy()).setMaxValue(this.getMaxValue()).setMinValue(this.getMinValue()).setOrdered(this.isOrdered()).setStartValue(this.getStartValue())};
    }

    @Override
    protected Change[] createInverses() {
        DropSequenceChange dropSequenceChange = new DropSequenceChange();
        dropSequenceChange.setSequenceName(this.getSequenceName());
        dropSequenceChange.setSchemaName(this.getSchemaName());
        return new Change[]{dropSequenceChange};
    }

    @Override
    public String getConfirmationMessage() {
        return "Sequence " + this.getSequenceName() + " created";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("createSequence");
        element.setAttribute("sequenceName", this.getSequenceName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        if (this.getMinValue() != null) {
            element.setAttribute("minValue", this.getMinValue().toString());
        }
        if (this.getMaxValue() != null) {
            element.setAttribute("maxValue", this.getMaxValue().toString());
        }
        if (this.getIncrementBy() != null) {
            element.setAttribute("incrementBy", this.getIncrementBy().toString());
        }
        if (this.isOrdered() != null) {
            element.setAttribute("ordered", this.isOrdered().toString());
        }
        if (this.getStartValue() != null) {
            element.setAttribute("startValue", this.getStartValue().toString());
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Sequence sequence = new Sequence();
        sequence.setName(this.sequenceName);
        return new HashSet<DatabaseObject>(Arrays.asList(sequence));
    }
}

