/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.OracleDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateProcedureChange
extends AbstractChange {
    private String comments;
    private String procedureBody;

    public CreateProcedureChange() {
        super("createProcedure", "Create Procedure");
    }

    public String getProcedureBody() {
        return this.procedureBody;
    }

    public void setProcedureBody(String string) {
        this.procedureBody = string;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.procedureBody) == null) {
            throw new InvalidChangeDefinitionException("procedure text is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        String string = ";";
        if (database instanceof OracleDatabase) {
            string = "\n/";
        }
        return new SqlStatement[]{new RawSqlStatement(this.getProcedureBody(), string)};
    }

    @Override
    public String getConfirmationMessage() {
        return "Stored procedure created";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        element.appendChild(document.createTextNode(this.getProcedureBody()));
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }
}

