/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DropIndexChange;
import liquibase.database.Database;
import liquibase.database.sql.CreateIndexStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateIndexChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private String indexName;
    private Boolean unique;
    private String tablespace;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public CreateIndexChange() {
        super("createIndex", "Create Index");
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> list) {
        this.columns = list;
    }

    @Override
    public void addColumn(ColumnConfig columnConfig) {
        this.columns.add(columnConfig);
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String string) {
        this.tablespace = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            if (StringUtils.trimToNull(columnConfig.getName()) != null) continue;
            throw new InvalidChangeDefinitionException("column name is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ColumnConfig columnConfig : this.getColumns()) {
            arrayList.add(columnConfig.getName());
        }
        return new SqlStatement[]{new CreateIndexStatement(this.getIndexName(), this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.isUnique(), arrayList.toArray(new String[this.getColumns().size()])).setTablespace(this.getTablespace())};
    }

    @Override
    protected Change[] createInverses() {
        DropIndexChange dropIndexChange = new DropIndexChange();
        dropIndexChange.setSchemaName(this.getSchemaName());
        dropIndexChange.setTableName(this.getTableName());
        dropIndexChange.setIndexName(this.getIndexName());
        return new Change[]{dropIndexChange};
    }

    @Override
    public String getConfirmationMessage() {
        return "Index " + this.getIndexName() + " created";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("createIndex");
        element.setAttribute("indexName", this.getIndexName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        if (this.unique != null) {
            if (this.unique.booleanValue()) {
                element.setAttribute("unique", "true");
            } else {
                element.setAttribute("unique", "false");
            }
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            Element element2 = document.createElement("column");
            element2.setAttribute("name", columnConfig.getName());
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Index index = new Index();
        index.setTable(new Table(this.tableName));
        index.setName(this.indexName);
        index.setUnique(this.unique);
        Table table = new Table(this.getTableName());
        return new HashSet<Comparable>(Arrays.asList(index, table));
    }

    public void setUnique(Boolean bl) {
        this.unique = bl;
    }

    public Boolean isUnique() {
        return this.unique;
    }
}

