/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import liquibase.change.ConstraintsConfig;
import liquibase.database.Database;
import liquibase.database.sql.ComputedDateValue;
import liquibase.database.sql.ComputedNumericValue;
import liquibase.database.structure.Column;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColumnConfig {
    private String name;
    private String type;
    private String value;
    private Number valueNumeric;
    private Date valueDate;
    private Boolean valueBoolean;
    private String defaultValue;
    private Number defaultValueNumeric;
    private Date defaultValueDate;
    private Boolean defaultValueBoolean;
    private ConstraintsConfig constraints;
    private Boolean autoIncrement;
    private String remarks;

    public ColumnConfig(Column column) {
        this.setName(column.getName());
        this.setType(column.getTypeName());
        if (column.getDefaultValue() != null) {
            this.setDefaultValue(column.getDefaultValue().toString());
        }
        this.setAutoIncrement(column.isAutoIncrement());
        ConstraintsConfig constraintsConfig = new ConstraintsConfig();
        constraintsConfig.setNullable(column.isNullable());
        constraintsConfig.setPrimaryKey(column.isPrimaryKey());
        constraintsConfig.setUnique(column.isUnique());
        this.setConstraints(constraintsConfig);
    }

    public ColumnConfig(ColumnConfig columnConfig) {
        this.setName(columnConfig.getName());
        this.setType(columnConfig.getType());
        this.setDefaultValue(columnConfig.getDefaultValue());
        this.setAutoIncrement(columnConfig.isAutoIncrement());
        if (columnConfig.getConstraints() != null) {
            ConstraintsConfig constraintsConfig = new ConstraintsConfig();
            constraintsConfig.setNullable(columnConfig.getConstraints().isNullable());
            constraintsConfig.setPrimaryKey(columnConfig.getConstraints().isPrimaryKey());
            constraintsConfig.setUnique(columnConfig.getConstraints().isUnique());
        }
        this.setConstraints(this.constraints);
    }

    public ColumnConfig() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public Number getValueNumeric() {
        return this.valueNumeric;
    }

    public void setValueNumeric(String string) {
        if (string == null || string.equalsIgnoreCase("null")) {
            this.valueNumeric = null;
        } else {
            string = string.replaceFirst("^\\(", "");
            if ((string = string.replaceFirst("\\)$", "")).matches("\\d+\\.?\\d*")) {
                try {
                    this.valueNumeric = NumberFormat.getInstance(Locale.US).parse(string);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(parseException);
                }
            } else {
                this.valueNumeric = new ComputedNumericValue(string);
            }
        }
    }

    public void setValueNumeric(Number number) {
        this.valueNumeric = number;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public void setValueBoolean(Boolean bl) {
        this.valueBoolean = bl;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date date) {
        this.valueDate = date;
    }

    public void setValueDate(String string) {
        if (string == null || string.equalsIgnoreCase("null")) {
            this.valueDate = null;
        }
        try {
            this.valueDate = new ISODateFormat().parse(string);
        }
        catch (ParseException parseException) {
            this.valueDate = new ComputedDateValue(string);
        }
    }

    public Object getValueObject() {
        if (this.getValue() != null) {
            return this.getValue();
        }
        if (this.getValueBoolean() != null) {
            return this.getValueBoolean();
        }
        if (this.getValueNumeric() != null) {
            return this.getValueNumeric();
        }
        if (this.getValueDate() != null) {
            return this.getValueDate();
        }
        return null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public Number getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public void setDefaultValueNumeric(Number number) {
        this.defaultValueNumeric = number;
    }

    public void setDefaultValueNumeric(String string) throws ParseException {
        if (string == null || string.equalsIgnoreCase("null")) {
            this.defaultValueNumeric = null;
        } else if ("GENERATED_BY_DEFAULT".equals(string)) {
            this.setAutoIncrement(true);
        } else {
            string = string.replaceFirst("^\\(", "");
            string = string.replaceFirst("\\)$", "");
            this.defaultValueNumeric = NumberFormat.getInstance(Locale.US).parse(string);
        }
    }

    public Date getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public void setDefaultValueDate(String string) {
        if (string == null || string.equalsIgnoreCase("null")) {
            this.defaultValueDate = null;
        }
        try {
            this.defaultValueDate = new ISODateFormat().parse(string);
        }
        catch (ParseException parseException) {
            this.defaultValueDate = new ComputedDateValue(string);
        }
    }

    public void setDefaultValueDate(Date date) {
        this.defaultValueDate = date;
    }

    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public void setDefaultValueBoolean(Boolean bl) {
        this.defaultValueBoolean = bl;
    }

    public Object getDefaultValueObject() {
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue();
        }
        if (this.getDefaultValueBoolean() != null) {
            return this.getDefaultValueBoolean();
        }
        if (this.getDefaultValueNumeric() != null) {
            return this.getDefaultValueNumeric();
        }
        if (this.getDefaultValueDate() != null) {
            return this.getDefaultValueDate();
        }
        return null;
    }

    public ConstraintsConfig getConstraints() {
        return this.constraints;
    }

    public void setConstraints(ConstraintsConfig constraintsConfig) {
        this.constraints = constraintsConfig;
    }

    public Boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(Boolean bl) {
        this.autoIncrement = bl;
    }

    public Element createNode(Document document) {
        ConstraintsConfig constraintsConfig;
        Element element = document.createElement("column");
        if (this.getName() != null) {
            element.setAttribute("name", this.getName());
        }
        if (this.getType() != null) {
            element.setAttribute("type", this.getType());
        }
        if (this.getDefaultValue() != null) {
            element.setAttribute("defaultValue", this.getDefaultValue());
        }
        if (this.getDefaultValueNumeric() != null) {
            element.setAttribute("defaultValueNumeric", this.getDefaultValueNumeric().toString());
        }
        if (this.getDefaultValueDate() != null) {
            element.setAttribute("defaultValueDate", new ISODateFormat().format(this.getDefaultValueDate()));
        }
        if (this.getDefaultValueBoolean() != null) {
            element.setAttribute("defaultValueBoolean", this.getDefaultValueBoolean().toString());
        }
        if (this.getValue() != null) {
            element.setAttribute("value", this.getValue());
        }
        if (this.getValueNumeric() != null) {
            element.setAttribute("valueNumeric", this.getValueNumeric().toString());
        }
        if (this.getValueBoolean() != null) {
            element.setAttribute("valueBoolean", this.getValueBoolean().toString());
        }
        if (this.getValueDate() != null) {
            element.setAttribute("valueDate", new ISODateFormat().format(this.getValueDate()));
        }
        if (StringUtils.trimToNull(this.getRemarks()) != null) {
            element.setAttribute("remarks", this.getRemarks());
        }
        if (this.isAutoIncrement() != null && this.isAutoIncrement().booleanValue()) {
            element.setAttribute("autoIncrement", "true");
        }
        if ((constraintsConfig = this.getConstraints()) != null) {
            Element element2 = document.createElement("constraints");
            if (constraintsConfig.getCheck() != null) {
                element2.setAttribute("check", constraintsConfig.getCheck());
            }
            if (constraintsConfig.getForeignKeyName() != null) {
                element2.setAttribute("foreignKeyName", constraintsConfig.getForeignKeyName());
            }
            if (constraintsConfig.getReferences() != null) {
                element2.setAttribute("references", constraintsConfig.getReferences());
            }
            if (constraintsConfig.isDeferrable() != null) {
                element2.setAttribute("deferrable", constraintsConfig.isDeferrable().toString());
            }
            if (constraintsConfig.isDeleteCascade() != null) {
                element2.setAttribute("deleteCascade", constraintsConfig.isDeleteCascade().toString());
            }
            if (constraintsConfig.isInitiallyDeferred() != null) {
                element2.setAttribute("initiallyDeferred", constraintsConfig.isInitiallyDeferred().toString());
            }
            if (constraintsConfig.isNullable() != null) {
                element2.setAttribute("nullable", constraintsConfig.isNullable().toString());
            }
            if (constraintsConfig.isPrimaryKey() != null) {
                element2.setAttribute("primaryKey", constraintsConfig.isPrimaryKey().toString());
            }
            if (constraintsConfig.isUnique() != null) {
                element2.setAttribute("unique", constraintsConfig.isUnique().toString());
            }
            if (constraintsConfig.getUniqueConstraintName() != null) {
                element2.setAttribute("uniqueConstraintName", constraintsConfig.getUniqueConstraintName());
            }
            if (constraintsConfig.getPrimaryKeyName() != null) {
                element2.setAttribute("primaryKeyName", constraintsConfig.getPrimaryKeyName());
            }
            element.appendChild(element2);
        }
        return element;
    }

    public String getDefaultColumnValue(Database database) {
        if (this.getDefaultValue() != null) {
            if ("null".equalsIgnoreCase(this.getDefaultValue())) {
                return "NULL";
            }
            if (!database.shouldQuoteValue(this.getDefaultValue())) {
                return this.getDefaultValue();
            }
            return "'" + this.getDefaultValue().replaceAll("'", "''") + "'";
        }
        if (this.getDefaultValueNumeric() != null) {
            return this.getDefaultValueNumeric().toString();
        }
        if (this.getDefaultValueBoolean() != null) {
            String string = this.getDefaultValueBoolean() != false ? database.getTrueBooleanValue() : database.getFalseBooleanValue();
            if (string.matches("\\d+")) {
                return string;
            }
            return "'" + string + "'";
        }
        if (this.getDefaultValueDate() != null) {
            Date date = this.getDefaultValueDate();
            return database.getDateLiteral(date);
        }
        return "NULL";
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null || this.getDefaultValueBoolean() != null || this.getDefaultValueDate() != null || this.getDefaultValueNumeric() != null;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }
}

