/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropPrimaryKeyChange;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddPrimaryKeyStatement;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPrimaryKeyChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String columnNames;
    private String constraintName;

    public AddPrimaryKeyChange() {
        super("addPrimaryKey", "Add Primary Key");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String string) {
        this.columnNames = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String string) {
        this.tablespace = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.columnNames) == null) {
            throw new InvalidChangeDefinitionException("columnNames is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        String string = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        AddPrimaryKeyStatement addPrimaryKeyStatement = new AddPrimaryKeyStatement(string, this.getTableName(), this.getColumnNames(), this.getConstraintName());
        addPrimaryKeyStatement.setTablespace(this.getTablespace());
        if (database instanceof DB2Database) {
            return new SqlStatement[]{addPrimaryKeyStatement, new ReorganizeTableStatement(string, this.getTableName())};
        }
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{addPrimaryKeyStatement};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig columnConfig) {
                String[] stringArray;
                for (String string : stringArray = AddPrimaryKeyChange.this.getColumnNames().split("[ ]*,[ ]*")) {
                    if (!columnConfig.getName().equals(string)) continue;
                    columnConfig.getConstraints().setPrimaryKey(true);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException jDBCException) {
            jDBCException.printStackTrace();
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropPrimaryKeyChange dropPrimaryKeyChange = new DropPrimaryKeyChange();
        dropPrimaryKeyChange.setSchemaName(this.getSchemaName());
        dropPrimaryKeyChange.setTableName(this.getTableName());
        dropPrimaryKeyChange.setConstraintName(this.getConstraintName());
        return new Change[]{dropPrimaryKeyChange};
    }

    @Override
    public String getConfirmationMessage() {
        return "Primary key added to " + this.getTableName() + " (" + this.getColumnNames() + ")";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("columnNames", this.getColumnNames());
        if (this.getConstraintName() != null) {
            element.setAttribute("constraintName", this.getConstraintName());
        }
        if (this.getTablespace() != null) {
            element.setAttribute("tablespace", this.getTablespace());
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> hashSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getTableName());
        hashSet.add(table);
        for (String string : this.columnNames.split(",")) {
            Column column = new Column();
            column.setTable(table);
            column.setName(string.trim());
            hashSet.add(column);
        }
        return hashSet;
    }
}

