/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.AddForeignKeyConstraintChange;
import liquibase.change.AddNotNullConstraintChange;
import liquibase.change.AddPrimaryKeyChange;
import liquibase.change.Change;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.change.DropTableChange;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddLookupTableChange
extends AbstractChange {
    private String existingTableSchemaName;
    private String existingTableName;
    private String existingColumnName;
    private String newTableSchemaName;
    private String newTableName;
    private String newColumnName;
    private String newColumnDataType;
    private String constraintName;

    public AddLookupTableChange() {
        super("addLookupTable", "Add Lookup Table");
    }

    public String getExistingTableSchemaName() {
        return this.existingTableSchemaName;
    }

    public void setExistingTableSchemaName(String string) {
        this.existingTableSchemaName = string;
    }

    public String getExistingTableName() {
        return this.existingTableName;
    }

    public void setExistingTableName(String string) {
        this.existingTableName = string;
    }

    public String getExistingColumnName() {
        return this.existingColumnName;
    }

    public void setExistingColumnName(String string) {
        this.existingColumnName = string;
    }

    public String getNewTableSchemaName() {
        return this.newTableSchemaName;
    }

    public void setNewTableSchemaName(String string) {
        this.newTableSchemaName = string;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String string) {
        this.newTableName = string;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String string) {
        this.newColumnName = string;
    }

    public String getNewColumnDataType() {
        return this.newColumnDataType;
    }

    public void setNewColumnDataType(String string) {
        this.newColumnDataType = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getFinalConstraintName() {
        if (this.constraintName == null) {
            return ("FK_" + this.getExistingTableName() + "_" + this.getNewTableName()).toUpperCase();
        }
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.existingTableName) == null) {
            throw new InvalidChangeDefinitionException("existingTableName is required", this);
        }
        if (StringUtils.trimToNull(this.existingColumnName) == null) {
            throw new InvalidChangeDefinitionException("existingColumnName is required", this);
        }
        if (StringUtils.trimToNull(this.newTableName) == null) {
            throw new InvalidChangeDefinitionException("newTableName is required", this);
        }
        if (StringUtils.trimToNull(this.newColumnName) == null) {
            throw new InvalidChangeDefinitionException("newColumnName is required", this);
        }
    }

    @Override
    protected Change[] createInverses() {
        DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
        dropForeignKeyConstraintChange.setBaseTableSchemaName(this.getExistingTableSchemaName());
        dropForeignKeyConstraintChange.setBaseTableName(this.getExistingTableName());
        dropForeignKeyConstraintChange.setConstraintName(this.getFinalConstraintName());
        DropTableChange dropTableChange = new DropTableChange();
        dropTableChange.setSchemaName(this.getNewTableSchemaName());
        dropTableChange.setTableName(this.getNewTableName());
        return new Change[]{dropForeignKeyConstraintChange, dropTableChange};
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        AbstractChange abstractChange;
        if (database instanceof DerbyDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table currently not supported in Derby");
        }
        if (database instanceof HsqlDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table currently not supported in HSQLDB");
        }
        if (database instanceof CacheDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table not currently supported for Cache");
        }
        if (database instanceof FirebirdDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table not currently supported for Firebird");
        }
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        String string = this.getNewTableSchemaName() == null ? database.getDefaultSchemaName() : this.getNewTableSchemaName();
        String string2 = this.getExistingTableSchemaName() == null ? database.getDefaultSchemaName() : this.getExistingTableSchemaName();
        SqlStatement[] sqlStatementArray = new SqlStatement[]{new RawSqlStatement("CREATE TABLE " + database.escapeTableName(string, this.getNewTableName()) + " AS SELECT DISTINCT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " FROM " + database.escapeTableName(string2, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        if (database instanceof MSSQLDatabase) {
            sqlStatementArray = new SqlStatement[]{new RawSqlStatement("SELECT DISTINCT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " INTO " + database.escapeTableName(string, this.getNewTableName()) + " FROM " + database.escapeTableName(string2, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        } else if (database instanceof SybaseASADatabase) {
            sqlStatementArray = new SqlStatement[]{new RawSqlStatement("SELECT DISTINCT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " INTO " + database.escapeTableName(string, this.getNewTableName()) + " FROM " + database.escapeTableName(string2, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        } else if (database instanceof DB2Database) {
            sqlStatementArray = new SqlStatement[]{new RawSqlStatement("CREATE TABLE " + database.escapeTableName(string, this.getNewTableName()) + " AS (SELECT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " FROM " + database.escapeTableName(string2, this.getExistingTableName()) + ") WITH NO DATA"), new RawSqlStatement("INSERT INTO " + database.escapeTableName(string, this.getNewTableName()) + " SELECT DISTINCT " + this.getExistingColumnName() + " FROM " + database.escapeTableName(string2, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        }
        arrayList.addAll(Arrays.asList(sqlStatementArray));
        if (!(database instanceof OracleDatabase)) {
            abstractChange = new AddNotNullConstraintChange();
            ((AddNotNullConstraintChange)abstractChange).setSchemaName(string);
            ((AddNotNullConstraintChange)abstractChange).setTableName(this.getNewTableName());
            ((AddNotNullConstraintChange)abstractChange).setColumnName(this.getNewColumnName());
            ((AddNotNullConstraintChange)abstractChange).setColumnDataType(this.getNewColumnDataType());
            arrayList.addAll(Arrays.asList(((AddNotNullConstraintChange)abstractChange).generateStatements(database)));
        }
        if (database instanceof DB2Database) {
            arrayList.add(new ReorganizeTableStatement(string, this.getNewTableName()));
        }
        abstractChange = new AddPrimaryKeyChange();
        ((AddPrimaryKeyChange)abstractChange).setSchemaName(string);
        ((AddPrimaryKeyChange)abstractChange).setTableName(this.getNewTableName());
        ((AddPrimaryKeyChange)abstractChange).setColumnNames(this.getNewColumnName());
        arrayList.addAll(Arrays.asList(((AddPrimaryKeyChange)abstractChange).generateStatements(database)));
        if (database instanceof DB2Database) {
            arrayList.add(new ReorganizeTableStatement(string, this.getNewTableName()));
        }
        AddForeignKeyConstraintChange addForeignKeyConstraintChange = new AddForeignKeyConstraintChange();
        addForeignKeyConstraintChange.setBaseTableSchemaName(string2);
        addForeignKeyConstraintChange.setBaseTableName(this.getExistingTableName());
        addForeignKeyConstraintChange.setBaseColumnNames(this.getExistingColumnName());
        addForeignKeyConstraintChange.setReferencedTableSchemaName(string);
        addForeignKeyConstraintChange.setReferencedTableName(this.getNewTableName());
        addForeignKeyConstraintChange.setReferencedColumnNames(this.getNewColumnName());
        addForeignKeyConstraintChange.setConstraintName(this.getFinalConstraintName());
        arrayList.addAll(Arrays.asList(addForeignKeyConstraintChange.generateStatements(database)));
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return "Lookup table added for " + this.getExistingTableName() + "." + this.getExistingColumnName();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getExistingTableSchemaName() != null) {
            element.setAttribute("newTableSchemaName", this.getExistingTableSchemaName());
        }
        element.setAttribute("existingTableName", this.getExistingTableName());
        element.setAttribute("existingColumnName", this.getExistingColumnName());
        if (this.getNewTableSchemaName() != null) {
            element.setAttribute("newTableSchemaName", this.getNewTableSchemaName());
        }
        element.setAttribute("newTableName", this.getNewTableName());
        element.setAttribute("newColumnName", this.getNewColumnName());
        element.setAttribute("constraintName", this.getConstraintName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> hashSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getExistingTableName());
        hashSet.add(table);
        Column column = new Column();
        column.setTable(table);
        column.setName(this.getExistingColumnName());
        hashSet.add(column);
        Table table2 = new Table(this.getNewTableName());
        hashSet.add(table2);
        Column column2 = new Column();
        column2.setTable(table);
        column2.setName(this.getNewColumnName());
        hashSet.add(column2);
        ForeignKey foreignKey = new ForeignKey();
        foreignKey.setForeignKeyTable(table);
        foreignKey.setForeignKeyColumns(column.getName());
        foreignKey.setPrimaryKeyTable(table2);
        foreignKey.setPrimaryKeyColumns(column2.getName());
        hashSet.add(foreignKey);
        return hashSet;
    }
}

