/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddForeignKeyConstraintStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddForeignKeyConstraintChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private String baseColumnNames;
    private String referencedTableSchemaName;
    private String referencedTableName;
    private String referencedColumnNames;
    private String constraintName;
    private Boolean deferrable;
    private Boolean initiallyDeferred;
    private Integer updateRule;
    private Integer deleteRule;

    public AddForeignKeyConstraintChange() {
        super("addForeignKeyConstraint", "Add Foreign Key Constraint");
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String string) {
        this.baseTableSchemaName = string;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String string) {
        this.baseTableName = string;
    }

    public String getBaseColumnNames() {
        return this.baseColumnNames;
    }

    public void setBaseColumnNames(String string) {
        this.baseColumnNames = string;
    }

    public String getReferencedTableSchemaName() {
        return this.referencedTableSchemaName;
    }

    public void setReferencedTableSchemaName(String string) {
        this.referencedTableSchemaName = string;
    }

    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    public void setReferencedTableName(String string) {
        this.referencedTableName = string;
    }

    public String getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public void setReferencedColumnNames(String string) {
        this.referencedColumnNames = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public Boolean getDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(Boolean bl) {
        this.deferrable = bl;
    }

    public Boolean getInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(Boolean bl) {
        this.initiallyDeferred = bl;
    }

    public void setDeleteCascade(Boolean bl) {
        if (bl != null && bl.booleanValue()) {
            this.setOnDelete("CASCADE");
        }
    }

    public void setUpdateRule(Integer n) {
        this.updateRule = n;
    }

    public Integer getUpdateRule() {
        return this.updateRule;
    }

    public void setDeleteRule(Integer n) {
        this.deleteRule = n;
    }

    public Integer getDeleteRule() {
        return this.deleteRule;
    }

    public void setOnDelete(String string) {
        if (string != null && string.equalsIgnoreCase("CASCADE")) {
            this.setDeleteRule(0);
        } else if (string != null && string.equalsIgnoreCase("SET NULL")) {
            this.setDeleteRule(2);
        } else if (string != null && string.equalsIgnoreCase("SET DEFAULT")) {
            this.setDeleteRule(4);
        } else if (string != null && string.equalsIgnoreCase("RESTRICT")) {
            this.setDeleteRule(1);
        } else if (string == null || string.equalsIgnoreCase("NO ACTION")) {
            this.setDeleteRule(3);
        } else {
            throw new RuntimeException("Unknown onDelete action: " + string);
        }
    }

    public void setOnUpdate(String string) {
        if (string != null && string.equalsIgnoreCase("CASCADE")) {
            this.setUpdateRule(0);
        } else if (string != null && string.equalsIgnoreCase("SET NULL")) {
            this.setUpdateRule(2);
        } else if (string != null && string.equalsIgnoreCase("SET DEFAULT")) {
            this.setUpdateRule(4);
        } else if (string != null && string.equalsIgnoreCase("RESTRICT")) {
            this.setUpdateRule(1);
        } else if (string == null || string.equalsIgnoreCase("NO ACTION")) {
            this.setUpdateRule(3);
        } else {
            throw new RuntimeException("Unknown onUpdate action: " + string);
        }
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.baseTableName) == null) {
            throw new InvalidChangeDefinitionException("baseTableName is required", this);
        }
        if (StringUtils.trimToNull(this.baseColumnNames) == null) {
            throw new InvalidChangeDefinitionException("baseColumnNames is required", this);
        }
        if (StringUtils.trimToNull(this.referencedTableName) == null) {
            throw new InvalidChangeDefinitionException("referencedTableName is required", this);
        }
        if (StringUtils.trimToNull(this.referencedColumnNames) == null) {
            throw new InvalidChangeDefinitionException("referenceColumnNames is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        boolean bl = false;
        if (this.getDeferrable() != null) {
            bl = this.getDeferrable();
        }
        boolean bl2 = false;
        if (this.getInitiallyDeferred() != null) {
            bl2 = this.getInitiallyDeferred();
        }
        return new SqlStatement[]{new AddForeignKeyConstraintStatement(this.getConstraintName(), this.getBaseTableSchemaName() == null ? database.getDefaultSchemaName() : this.getBaseTableSchemaName(), this.getBaseTableName(), this.getBaseColumnNames(), this.getReferencedTableSchemaName() == null ? database.getDefaultSchemaName() : this.getReferencedTableSchemaName(), this.getReferencedTableName(), this.getReferencedColumnNames()).setDeferrable(bl).setInitiallyDeferred(bl2).setUpdateRule(this.updateRule).setDeleteRule(this.deleteRule)};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        return new SqlStatement[0];
    }

    @Override
    protected Change[] createInverses() {
        DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
        dropForeignKeyConstraintChange.setBaseTableSchemaName(this.getBaseTableSchemaName());
        dropForeignKeyConstraintChange.setBaseTableName(this.getBaseTableName());
        dropForeignKeyConstraintChange.setConstraintName(this.getConstraintName());
        return new Change[]{dropForeignKeyConstraintChange};
    }

    @Override
    public String getConfirmationMessage() {
        return "Foreign key contraint added to " + this.getBaseTableName() + " (" + this.getBaseColumnNames() + ")";
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getBaseTableSchemaName() != null) {
            element.setAttribute("baseTableSchemaName", this.getBaseTableSchemaName());
        }
        element.setAttribute("baseTableName", this.getBaseTableName());
        element.setAttribute("baseColumnNames", this.getBaseColumnNames());
        element.setAttribute("constraintName", this.getConstraintName());
        if (this.getReferencedTableSchemaName() != null) {
            element.setAttribute("referencedTableSchemaName", this.getReferencedTableSchemaName());
        }
        element.setAttribute("referencedTableName", this.getReferencedTableName());
        element.setAttribute("referencedColumnNames", this.getReferencedColumnNames());
        if (this.getDeferrable() != null) {
            element.setAttribute("deferrable", this.getDeferrable().toString());
        }
        if (this.getInitiallyDeferred() != null) {
            element.setAttribute("initiallyDeferred", this.getInitiallyDeferred().toString());
        }
        if (this.getUpdateRule() != null) {
            switch (this.getUpdateRule()) {
                case 0: {
                    element.setAttribute("onUpdate", "CASCADE");
                    break;
                }
                case 2: {
                    element.setAttribute("onUpdate", "SET NULL");
                    break;
                }
                case 4: {
                    element.setAttribute("onUpdate", "SET DEFAULT");
                    break;
                }
                case 1: {
                    element.setAttribute("onUpdate", "RESTRICT");
                    break;
                }
            }
        }
        if (this.getDeleteRule() != null) {
            switch (this.getDeleteRule()) {
                case 0: {
                    element.setAttribute("onDelete", "CASCADE");
                    break;
                }
                case 2: {
                    element.setAttribute("onDelete", "SET NULL");
                    break;
                }
                case 4: {
                    element.setAttribute("onDelete", "SET DEFAULT");
                    break;
                }
                case 1: {
                    element.setAttribute("onDelete", "RESTRICT");
                    break;
                }
            }
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> hashSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getBaseTableName());
        hashSet.add(table);
        for (String string : this.getBaseColumnNames().split(",")) {
            Column column = new Column();
            column.setTable(table);
            column.setName(string.trim());
            hashSet.add(column);
        }
        Table table2 = new Table(this.getReferencedTableName());
        hashSet.add(table2);
        for (String string : this.getReferencedColumnNames().split(",")) {
            Column column = new Column();
            column.setTable(table);
            column.setName(string.trim());
            hashSet.add(column);
        }
        ForeignKey foreignKey = new ForeignKey();
        foreignKey.setName(this.constraintName);
        foreignKey.setForeignKeyTable(table);
        foreignKey.setForeignKeyColumns(this.baseColumnNames);
        foreignKey.setPrimaryKeyTable(table2);
        foreignKey.setPrimaryKeyColumns(this.referencedColumnNames);
        foreignKey.setDeleteRule(this.deleteRule);
        foreignKey.setUpdateRule(this.updateRule);
        hashSet.add(foreignKey);
        return hashSet;
    }
}

