/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddDefaultValueStatement;
import liquibase.database.sql.ComputedDateValue;
import liquibase.database.sql.ComputedNumericValue;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDefaultValueChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String defaultValue;
    private String defaultValueNumeric;
    private String defaultValueDate;
    private Boolean defaultValueBoolean;

    public AddDefaultValueChange() {
        super("addDefaultValue", "Add Default Value");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public void setDefaultValueNumeric(String string) {
        this.defaultValueNumeric = string;
    }

    public String getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public void setDefaultValueDate(String string) {
        this.defaultValueDate = string;
    }

    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public void setDefaultValueBoolean(Boolean bl) {
        this.defaultValueBoolean = bl;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.columnName) == null) {
            throw new InvalidChangeDefinitionException("columnName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        Object object = null;
        if (this.getDefaultValue() != null) {
            object = this.getDefaultValue();
        } else if (this.getDefaultValueBoolean() != null) {
            object = (boolean)this.getDefaultValueBoolean();
        } else if (this.getDefaultValueNumeric() != null) {
            try {
                object = NumberFormat.getInstance(Locale.US).parse(this.getDefaultValueNumeric());
            }
            catch (ParseException parseException) {
                object = new ComputedNumericValue(this.getDefaultValueNumeric());
            }
        } else if (this.getDefaultValueDate() != null) {
            try {
                object = new ISODateFormat().parse(this.getDefaultValueDate());
            }
            catch (ParseException parseException) {
                object = new ComputedDateValue(this.getDefaultValueDate());
            }
        }
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database, object);
        }
        return new SqlStatement[]{new AddDefaultValueStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.getColumnName(), object)};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database, Object object) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig columnConfig) {
                if (columnConfig.getName().equals(AddDefaultValueChange.this.getColumnName())) {
                    try {
                        if (AddDefaultValueChange.this.getDefaultValue() != null) {
                            columnConfig.setDefaultValue(AddDefaultValueChange.this.getDefaultValue());
                        }
                        if (AddDefaultValueChange.this.getDefaultValueBoolean() != null) {
                            columnConfig.setDefaultValueBoolean(AddDefaultValueChange.this.getDefaultValueBoolean());
                        }
                        if (AddDefaultValueChange.this.getDefaultValueDate() != null) {
                            columnConfig.setDefaultValueDate(AddDefaultValueChange.this.getDefaultValueDate());
                        }
                        if (AddDefaultValueChange.this.getDefaultValueNumeric() != null) {
                            columnConfig.setDefaultValueNumeric(AddDefaultValueChange.this.getDefaultValueNumeric());
                        }
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException jDBCException) {
            jDBCException.printStackTrace();
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropDefaultValueChange dropDefaultValueChange = new DropDefaultValueChange();
        dropDefaultValueChange.setSchemaName(this.getSchemaName());
        dropDefaultValueChange.setTableName(this.getTableName());
        dropDefaultValueChange.setColumnName(this.getColumnName());
        return new Change[]{dropDefaultValueChange};
    }

    @Override
    public String getConfirmationMessage() {
        return "Default value added to " + this.getTableName() + "." + this.getColumnName();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("columnName", this.getColumnName());
        if (this.getDefaultValue() != null) {
            element.setAttribute("defaultValue", this.getDefaultValue());
        }
        if (this.getDefaultValueNumeric() != null) {
            element.setAttribute("defaultValueNumeric", this.getDefaultValueNumeric());
        }
        if (this.getDefaultValueDate() != null) {
            element.setAttribute("defaultValueDate", this.getDefaultValueDate());
        }
        if (this.getDefaultValueBoolean() != null) {
            element.setAttribute("defaultValueBoolean", this.getDefaultValueBoolean().toString());
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Column column = new Column();
        Table table = new Table(this.getTableName());
        column.setTable(table);
        column.setName(this.columnName);
        return new HashSet<Comparable>(Arrays.asList(table, column));
    }
}

