/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DropColumnChange;
import liquibase.change.DropDefaultValueChange;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddColumnStatement;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public AddColumnChange() {
        super("addColumn", "Add Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public ColumnConfig getLastColumn() {
        return this.columns.size() > 0 ? this.columns.get(this.columns.size() - 1) : null;
    }

    @Override
    public void addColumn(ColumnConfig columnConfig) {
        this.columns.add(columnConfig);
    }

    public void removeColumn(ColumnConfig columnConfig) {
        this.columns.remove(columnConfig);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            if (StringUtils.trimToNull(columnConfig.getName()) == null) {
                throw new InvalidChangeDefinitionException("column name is required", this);
            }
            if (StringUtils.trimToNull(columnConfig.getType()) != null) continue;
            throw new InvalidChangeDefinitionException("column type is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        String string = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        for (ColumnConfig columnConfig : this.columns) {
            HashSet<ColumnConstraint> hashSet = new HashSet<ColumnConstraint>();
            if (columnConfig.getConstraints() != null) {
                if (columnConfig.getConstraints().isNullable() != null && !columnConfig.getConstraints().isNullable().booleanValue()) {
                    hashSet.add(new NotNullConstraint());
                }
                if (columnConfig.getConstraints().isPrimaryKey() != null && columnConfig.getConstraints().isPrimaryKey().booleanValue()) {
                    hashSet.add(new PrimaryKeyConstraint(columnConfig.getConstraints().getPrimaryKeyName()));
                }
            }
            if (columnConfig.isAutoIncrement() != null && columnConfig.isAutoIncrement().booleanValue()) {
                hashSet.add(new AutoIncrementConstraint(columnConfig.getName()));
            }
            AddColumnStatement addColumnStatement = new AddColumnStatement(string, this.getTableName(), columnConfig.getName(), columnConfig.getType(), columnConfig.getDefaultValueObject(), hashSet.toArray(new ColumnConstraint[hashSet.size()]));
            arrayList.add(addColumnStatement);
            if (columnConfig.getValueObject() == null) continue;
            UpdateStatement updateStatement = new UpdateStatement(string, this.getTableName());
            updateStatement.addNewColumnValue(columnConfig.getName(), columnConfig.getValueObject());
            arrayList.add(updateStatement);
        }
        if (database instanceof DB2Database) {
            arrayList.add(new ReorganizeTableStatement(string, this.getTableName()));
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                ColumnConfig[] columnConfigArray = new ColumnConfig[AddColumnChange.this.columns.size()];
                for (int i = 0; i < AddColumnChange.this.columns.size(); ++i) {
                    columnConfigArray[i] = new ColumnConfig((ColumnConfig)AddColumnChange.this.columns.get(i));
                }
                return columnConfigArray;
            }

            public boolean copyThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException jDBCException) {
            this.log.log(Level.WARNING, "unable to add column", jDBCException);
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    protected Change[] createInverses() {
        ArrayList<AbstractChange> arrayList = new ArrayList<AbstractChange>();
        for (ColumnConfig columnConfig : this.columns) {
            AbstractChange abstractChange;
            if (columnConfig.hasDefaultValue()) {
                abstractChange = new DropDefaultValueChange();
                ((DropDefaultValueChange)abstractChange).setTableName(this.getTableName());
                ((DropDefaultValueChange)abstractChange).setColumnName(columnConfig.getName());
                arrayList.add(abstractChange);
            }
            abstractChange = new DropColumnChange();
            ((DropColumnChange)abstractChange).setSchemaName(this.getSchemaName());
            ((DropColumnChange)abstractChange).setColumnName(columnConfig.getName());
            ((DropColumnChange)abstractChange).setTableName(this.getTableName());
            arrayList.add(abstractChange);
        }
        return arrayList.toArray(new Change[arrayList.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        ArrayList<String> arrayList = new ArrayList<String>(this.columns.size());
        for (ColumnConfig columnConfig : this.columns) {
            arrayList.add(columnConfig.getName() + "(" + columnConfig.getType() + ")");
        }
        return "Columns " + StringUtils.join(arrayList, ",") + " added to " + this.tableName;
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("addColumn");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        for (ColumnConfig columnConfig : this.getColumns()) {
            Element element2 = columnConfig.createNode(document);
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        ArrayList<DatabaseObject> arrayList = new ArrayList<DatabaseObject>(this.columns.size());
        Table table = new Table(this.getTableName());
        arrayList.add(table);
        for (ColumnConfig columnConfig : this.columns) {
            Column column = new Column();
            column.setTable(table);
            column.setName(columnConfig.getName());
            arrayList.add(column);
        }
        return new HashSet<DatabaseObject>(arrayList);
    }
}

