/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.PostgresDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddAutoIncrementStatement;
import liquibase.database.sql.AddDefaultValueStatement;
import liquibase.database.sql.CreateSequenceStatement;
import liquibase.database.sql.SetNullableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAutoIncrementChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;

    public AddAutoIncrementChange() {
        super("addAutoIncrement", "Set Column as Auto-Increment");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = StringUtils.trimToNull(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String string) {
        this.columnDataType = string;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        String string;
        String string2 = string = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        if (database instanceof PostgresDatabase) {
            String string3 = (this.getTableName() + "_" + this.getColumnName() + "_seq").toLowerCase();
            return new SqlStatement[]{new CreateSequenceStatement(string, string3), new SetNullableStatement(string, this.getTableName(), this.getColumnName(), null, false), new AddDefaultValueStatement(string, this.getTableName(), this.getColumnName(), string3)};
        }
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{new AddAutoIncrementStatement(string, this.getTableName(), this.getColumnName(), this.getColumnDataType())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor alterTableVisitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig columnConfig) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig columnConfig) {
                if (columnConfig.getName().equals(AddAutoIncrementChange.this.getColumnName())) {
                    columnConfig.setAutoIncrement(true);
                    columnConfig.setType("INTEGER");
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            arrayList.addAll(SQLiteDatabase.getAlterTableStatements(alterTableVisitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException jDBCException) {
            jDBCException.printStackTrace();
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return "Auto-increment added to " + this.getTableName() + "." + this.getColumnName();
    }

    @Override
    public Element createNode(Document document) {
        Element element = document.createElement("addAutoIncrement");
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("columnName", this.getColumnName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        if (this.getColumnDataType() != null) {
            element.setAttribute("columnDataType", this.getColumnDataType());
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Column column = new Column();
        Table table = new Table(this.getTableName());
        column.setTable(table);
        column.setName(this.columnName);
        return new HashSet<Comparable>(Arrays.asList(table, column));
    }
}

