/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;

public abstract class AbstractSQLChange
extends AbstractChange {
    private boolean stripComments = false;
    private boolean splitStatements = true;
    private String endDelimiter = ";";
    private String sql;

    protected AbstractSQLChange(String string, String string2) {
        super(string, string2);
    }

    public void setStripComments(Boolean bl) {
        this.stripComments = bl;
    }

    public boolean isStrippingComments() {
        return this.stripComments;
    }

    public void setSplitStatements(Boolean bl) {
        this.splitStatements = bl;
    }

    public boolean isSplittingStatements() {
        return this.splitStatements;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String string) {
        this.endDelimiter = string;
    }

    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.getSql()) == null) {
            throw new InvalidChangeDefinitionException("sql text is required", this);
        }
    }

    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<RawSqlStatement> arrayList = new ArrayList<RawSqlStatement>();
        String string = this.isStrippingComments() ? StringUtils.stripComments(this.getSql()) : this.getSql();
        string = string.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        if (this.isSplittingStatements()) {
            String[] stringArray;
            for (String string2 : stringArray = StringUtils.splitSQL(string)) {
                arrayList.add(new RawSqlStatement(string2, this.getEndDelimiter()));
            }
        } else {
            arrayList.add(new RawSqlStatement(string, this.getEndDelimiter()));
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }
}

