/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.ChangeSet;
import liquibase.FileOpener;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.exception.JDBCException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.log.LogFactory;
import liquibase.util.MD5Util;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChange
implements Change {
    private final String changeName;
    private final String tagName;
    private FileOpener fileOpener;
    private ChangeSet changeSet;
    protected Logger log;

    protected AbstractChange(String string, String string2) {
        this.tagName = string;
        this.changeName = string2;
        this.log = LogFactory.getLogger();
    }

    @Override
    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    public String getChangeName() {
        return this.changeName;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public void executeStatements(Database database, List<SqlVisitor> list) throws JDBCException, UnsupportedChangeException {
        SqlStatement[] sqlStatementArray = this.generateStatements(database);
        this.execute(sqlStatementArray, list, database);
    }

    @Override
    public void saveStatements(Database database, List<SqlVisitor> list, Writer writer) throws IOException, UnsupportedChangeException, StatementNotSupportedOnDatabaseException {
        SqlStatement[] sqlStatementArray;
        for (SqlStatement sqlStatement : sqlStatementArray = this.generateStatements(database)) {
            writer.append(sqlStatement.getSqlStatement(database)).append(sqlStatement.getEndDelimiter(database)).append(StreamUtil.getLineSeparator()).append(StreamUtil.getLineSeparator());
        }
    }

    @Override
    public void executeRollbackStatements(Database database, List<SqlVisitor> list) throws JDBCException, UnsupportedChangeException, RollbackImpossibleException {
        SqlStatement[] sqlStatementArray = this.generateRollbackStatements(database);
        this.execute(sqlStatementArray, list, database);
    }

    @Override
    public void saveRollbackStatement(Database database, List<SqlVisitor> list, Writer writer) throws IOException, UnsupportedChangeException, RollbackImpossibleException, StatementNotSupportedOnDatabaseException {
        SqlStatement[] sqlStatementArray;
        for (SqlStatement sqlStatement : sqlStatementArray = this.generateRollbackStatements(database)) {
            writer.append(sqlStatement.getSqlStatement(database)).append(";\n\n");
        }
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        return this.generateRollbackStatementsFromInverse(database);
    }

    @Override
    public boolean canRollBack() {
        return this.createInverses() != null;
    }

    @Override
    public String getMD5Sum() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.nodeToStringBuffer(this.createNode(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()), stringBuffer);
            return MD5Util.computeMD5(stringBuffer.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    private SqlStatement[] generateRollbackStatementsFromInverse(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        Change[] changeArray = this.createInverses();
        if (changeArray == null) {
            throw new RollbackImpossibleException("No inverse to " + this.getClass().getName() + " created");
        }
        ArrayList<SqlStatement> arrayList = new ArrayList<SqlStatement>();
        for (Change change : changeArray) {
            arrayList.addAll(Arrays.asList(change.generateStatements(database)));
        }
        return arrayList.toArray(new SqlStatement[arrayList.size()]);
    }

    protected Change[] createInverses() {
        return null;
    }

    private void nodeToStringBuffer(Node node, StringBuffer stringBuffer) {
        Object object;
        stringBuffer.append("<").append(node.getNodeName());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Map.Entry entry = namedNodeMap.item(i);
            treeMap.put(entry.getNodeName(), entry.getNodeValue());
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            object = (String)entry.getValue();
            if (object == null) continue;
            stringBuffer.append(" ").append(entry.getKey()).append("=\"").append((String)object).append("\"");
        }
        stringBuffer.append(">").append(StringUtils.trimToEmpty(XMLUtil.getTextContent(node)));
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            if (!(object instanceof Element)) continue;
            this.nodeToStringBuffer((Element)object, stringBuffer);
        }
        stringBuffer.append("</").append(node.getNodeName()).append(">");
    }

    private void execute(SqlStatement[] sqlStatementArray, List<SqlVisitor> list, Database database) throws JDBCException {
        for (SqlStatement sqlStatement : sqlStatementArray) {
            LogFactory.getLogger().finest("Executing Statement: " + sqlStatement);
            database.getJdbcTemplate().execute(sqlStatement, list);
        }
    }

    @Override
    public void setFileOpener(FileOpener fileOpener) {
        this.fileOpener = fileOpener;
    }

    public FileOpener getFileOpener() {
        return this.fileOpener;
    }

    @Override
    public void setUp() throws SetupException {
    }
}

