/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ant;

import java.io.PrintStream;
import liquibase.Liquibase;
import liquibase.ant.BaseLiquibaseTask;
import liquibase.database.Database;
import liquibase.diff.Diff;
import liquibase.diff.DiffResult;
import org.apache.tools.ant.BuildException;

public class GenerateChangeLogTask
extends BaseLiquibaseTask {
    public void execute() throws BuildException {
        Liquibase liquibase = null;
        try {
            PrintStream printStream = this.createPrintStream();
            if (printStream == null) {
                throw new BuildException("generateChangeLog requires outputFile to be set");
            }
            liquibase = this.createLiquibase();
            Database database = liquibase.getDatabase();
            Diff diff = new Diff(database, this.getDefaultSchemaName());
            DiffResult diffResult = diff.compare();
            if (this.getChangeLogFile() == null) {
                diffResult.printChangeLog(printStream, database);
            } else {
                diffResult.printChangeLog(this.getChangeLogFile(), database);
            }
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            try {
                throw new BuildException((Throwable)exception);
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
        this.closeDatabase(liquibase);
    }
}

