/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ant;

import java.io.PrintStream;
import liquibase.Liquibase;
import liquibase.ant.BaseLiquibaseTask;
import liquibase.database.Database;
import liquibase.diff.Diff;
import liquibase.diff.DiffResult;
import liquibase.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class DiffDatabaseTask
extends BaseLiquibaseTask {
    private String baseDriver;
    private String baseUrl;
    private String baseUsername;
    private String basePassword;
    private String baseDefaultSchemaName;

    public String getBaseDriver() {
        if (this.baseDriver == null) {
            return this.getDriver();
        }
        return this.baseDriver;
    }

    public void setBaseDriver(String string) {
        this.baseDriver = string;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public String getBaseUsername() {
        return this.baseUsername;
    }

    public void setBaseUsername(String string) {
        this.baseUsername = string;
    }

    public String getBasePassword() {
        return this.basePassword;
    }

    public void setBasePassword(String string) {
        this.basePassword = string;
    }

    public String getBaseDefaultSchemaName() {
        return this.baseDefaultSchemaName;
    }

    public void setBaseDefaultSchemaName(String string) {
        this.baseDefaultSchemaName = string;
    }

    public void execute() throws BuildException {
        if (StringUtils.trimToNull(this.getBaseUrl()) == null) {
            throw new BuildException("diffDatabase requires baseUrl to be set");
        }
        if (!this.getBaseUrl().startsWith("hibernate") && StringUtils.trimToNull(this.getBaseUsername()) == null) {
            throw new BuildException("diffDatabase requires baseUsername to be set");
        }
        if (!this.getBaseUrl().startsWith("hibernate") && StringUtils.trimToNull(this.getBasePassword()) == null) {
            throw new BuildException("diffDatabase requires basePassword to be set");
        }
        Liquibase liquibase = null;
        try {
            PrintStream printStream = this.createPrintStream();
            if (printStream == null && this.getChangeLogFile() == null) {
                throw new BuildException("diffDatabase requires outputFile or changeLogFile to be set");
            }
            liquibase = this.createLiquibase();
            Database database = this.createDatabaseObject(this.getBaseDriver(), this.getBaseUrl(), this.getBaseUsername(), this.getBasePassword(), this.getBaseDefaultSchemaName(), this.getDatabaseClass());
            Diff diff = new Diff(database, liquibase.getDatabase());
            DiffResult diffResult = diff.compare();
            this.outputDiff(printStream, diffResult, liquibase.getDatabase());
            if (printStream != null) {
                printStream.flush();
                printStream.close();
            }
        }
        catch (Exception exception) {
            try {
                throw new BuildException((Throwable)exception);
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
        this.closeDatabase(liquibase);
    }

    protected void outputDiff(PrintStream printStream, DiffResult diffResult, Database database) throws Exception {
        diffResult.printResult(printStream);
    }
}

