/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import liquibase.CompositeFileOpener;
import liquibase.FileOpener;
import liquibase.FileSystemFileOpener;
import liquibase.Liquibase;
import liquibase.ant.AntFileOpener;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.HibernateDatabase;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class BaseLiquibaseTask
extends Task {
    private String changeLogFile;
    private String driver;
    private String url;
    private String username;
    private String password;
    protected Path classpath;
    private boolean promptOnNonLocalDatabase = false;
    private String currentDateTimeFunction;
    private String contexts;
    private String outputFile;
    private String defaultSchemaName;
    private String databaseClass;
    private String databaseChangeLogTableName;
    private String databaseChangeLogLockTableName;
    private Map<String, Object> changeLogProperties = new HashMap<String, Object>();

    public BaseLiquibaseTask() {
        new LogRedirector(this).redirectLogger();
    }

    public boolean isPromptOnNonLocalDatabase() {
        return this.promptOnNonLocalDatabase;
    }

    public void setPromptOnNonLocalDatabase(boolean bl) {
        this.promptOnNonLocalDatabase = bl;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string.trim();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string.trim();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string.trim();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string.trim();
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String string) {
        this.changeLogFile = string.trim();
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public String getCurrentDateTimeFunction() {
        return this.currentDateTimeFunction;
    }

    public void setCurrentDateTimeFunction(String string) {
        this.currentDateTimeFunction = string.trim();
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String string) {
        this.outputFile = string.trim();
    }

    public Writer createOutputWriter() throws IOException {
        if (this.outputFile == null) {
            return null;
        }
        return new FileWriter(new File(this.getOutputFile()));
    }

    public PrintStream createPrintStream() throws IOException {
        if (this.outputFile == null) {
            return null;
        }
        return new PrintStream(new File(this.getOutputFile()));
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String string) {
        this.defaultSchemaName = string.trim();
    }

    public void addConfiguredChangeLogProperty(ChangeLogProperty changeLogProperty) {
        this.changeLogProperties.put(changeLogProperty.getName(), changeLogProperty.getValue());
    }

    protected Liquibase createLiquibase() throws Exception {
        AntFileOpener antFileOpener = new AntFileOpener(this.getProject(), this.classpath);
        FileSystemFileOpener fileSystemFileOpener = new FileSystemFileOpener();
        Database database = this.createDatabaseObject(this.getDriver(), this.getUrl(), this.getUsername(), this.getPassword(), this.getDefaultSchemaName(), this.getDatabaseClass());
        String string = null;
        if (this.getChangeLogFile() != null) {
            string = this.getChangeLogFile().trim();
        }
        Liquibase liquibase = new Liquibase(string, (FileOpener)new CompositeFileOpener(antFileOpener, fileSystemFileOpener), database);
        liquibase.setCurrentDateTimeFunction(this.currentDateTimeFunction);
        for (Map.Entry<String, Object> entry : this.changeLogProperties.entrySet()) {
            liquibase.setChangeLogParameterValue(entry.getKey(), entry.getValue());
        }
        return liquibase;
    }

    protected Database createDatabaseObject(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        Database database;
        Object object;
        String[] stringArray = this.classpath.list();
        final ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string7 : stringArray) {
            object = new File(string7).toURL();
            arrayList.add((URL)object);
        }
        URLClassLoader uRLClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]));
            }
        });
        if (string2.startsWith("hibernate:")) {
            database = new HibernateDatabase(string2.substring("hibernate:".length()));
        } else {
            if (string6 != null) {
                try {
                    DatabaseFactory.getInstance().addDatabaseImplementation((Database)Class.forName(string6, true, uRLClassLoader).newInstance());
                }
                catch (ClassCastException driver) {
                    DatabaseFactory.getInstance().addDatabaseImplementation((Database)Class.forName(string6).newInstance());
                }
            }
            if (string == null) {
                string = DatabaseFactory.getInstance().findDefaultDriver(string2);
            }
            if (string == null) {
                throw new JDBCException("driver not specified and no default could be found for " + string2);
            }
            Driver driver = (Driver)Class.forName(string, true, uRLClassLoader).newInstance();
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            object = driver.connect(string2, properties);
            if (object == null) {
                throw new JDBCException("Connection could not be created to " + string2 + " with driver " + driver.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
            }
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((Connection)object);
            database.setDefaultSchemaName(string5);
        }
        if (this.getDatabaseChangeLogTableName() != null) {
            database.setDatabaseChangeLogTableName(this.getDatabaseChangeLogTableName());
        }
        if (this.getDatabaseChangeLogLockTableName() != null) {
            database.setDatabaseChangeLogLockTableName(this.getDatabaseChangeLogLockTableName());
        }
        return database;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String string) {
        this.contexts = string.trim();
    }

    protected boolean shouldRun() {
        String string = System.getProperty("liquibase.should.run");
        if (string != null && !Boolean.valueOf(string).booleanValue()) {
            this.log("LiquiBase did not run because 'liquibase.should.run' system property was set to false");
            return false;
        }
        return true;
    }

    protected void closeDatabase(Liquibase liquibase) {
        if (liquibase != null && liquibase.getDatabase() != null && liquibase.getDatabase().getConnection() != null) {
            try {
                liquibase.getDatabase().close();
            }
            catch (JDBCException jDBCException) {
                this.log("Error closing database: " + jDBCException.getMessage());
            }
        }
    }

    public String getDatabaseClass() {
        return this.databaseClass;
    }

    public void setDatabaseClass(String string) {
        this.databaseClass = string;
    }

    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    public void setDatabaseChangeLogTableName(String string) {
        this.databaseChangeLogTableName = string;
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    public void setDatabaseChangeLogLockTableName(String string) {
        this.databaseChangeLogLockTableName = string;
    }

    public static class ChangeLogProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    protected static class LogRedirector {
        private final Task task;

        protected LogRedirector(Task task) {
            this.task = task;
        }

        protected void redirectLogger() {
            this.registerHandler(this.createHandler());
        }

        protected void registerHandler(Handler handler) {
            Logger logger = LogFactory.getLogger();
            for (Handler handler2 : logger.getHandlers()) {
                logger.removeHandler(handler2);
            }
            logger.addHandler(handler);
            logger.setUseParentHandlers(false);
        }

        protected Handler createHandler() {
            return new Handler(){

                public void publish(LogRecord logRecord) {
                    LogRedirector.this.task.log(logRecord.getMessage(), this.mapLevelToAntLevel(logRecord.getLevel()));
                }

                public void close() throws SecurityException {
                }

                public void flush() {
                }

                protected int mapLevelToAntLevel(Level level) {
                    if (Level.ALL == level) {
                        return 2;
                    }
                    if (Level.SEVERE == level) {
                        return 0;
                    }
                    if (Level.WARNING == level) {
                        return 1;
                    }
                    if (Level.INFO == level) {
                        return 2;
                    }
                    return 3;
                }
            };
        }
    }
}

