/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.Date;
import liquibase.ChangeSet;

public class RanChangeSet {
    private final String changeLog;
    private final String id;
    private final String author;
    private final String md5sum;
    private final Date dateExecuted;
    private String tag;

    public RanChangeSet(ChangeSet changeSet) {
        this(changeSet.getFilePath(), changeSet.getId(), changeSet.getAuthor(), changeSet.getMd5sum(), new Date(), null);
    }

    public RanChangeSet(String string, String string2, String string3, String string4, Date date, String string5) {
        this.changeLog = string;
        this.id = string2;
        this.author = string3;
        this.md5sum = string4;
        this.dateExecuted = date == null ? null : new Date(date.getTime());
        this.tag = string5;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public Date getDateExecuted() {
        if (this.dateExecuted == null) {
            return null;
        }
        return (Date)this.dateExecuted.clone();
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RanChangeSet ranChangeSet = (RanChangeSet)object;
        return this.author.equals(ranChangeSet.author) && this.changeLog.equals(ranChangeSet.changeLog) && this.id.equals(ranChangeSet.id);
    }

    public int hashCode() {
        int n = this.changeLog.hashCode();
        n = 29 * n + this.id.hashCode();
        n = 29 * n + this.author.hashCode();
        return n;
    }

    public boolean isSameAs(ChangeSet changeSet) {
        return this.getChangeLog().replace('\\', '/').equals(changeSet.getFilePath().replace('\\', '/')) && this.getId().equals(changeSet.getId()) && this.getAuthor().equals(changeSet.getAuthor());
    }
}

