/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.DatabaseChangeLogLock;
import liquibase.FileOpener;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.template.JdbcOutputTemplate;
import liquibase.database.template.JdbcTemplate;
import liquibase.exception.JDBCException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.lock.LockHandler;
import liquibase.log.LogFactory;
import liquibase.parser.ChangeLogIterator;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.filter.AfterTagChangeSetFilter;
import liquibase.parser.filter.AlreadyRanChangeSetFilter;
import liquibase.parser.filter.ContextChangeSetFilter;
import liquibase.parser.filter.CountChangeSetFilter;
import liquibase.parser.filter.DbmsChangeSetFilter;
import liquibase.parser.filter.ExecutedAfterChangeSetFilter;
import liquibase.parser.filter.NotRanChangeSetFilter;
import liquibase.parser.filter.ShouldRunChangeSetFilter;
import liquibase.parser.visitor.ChangeLogSyncVisitor;
import liquibase.parser.visitor.DBDocVisitor;
import liquibase.parser.visitor.ListVisitor;
import liquibase.parser.visitor.RollbackVisitor;
import liquibase.parser.visitor.UpdateVisitor;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Liquibase {
    public static final String SHOULD_RUN_SYSTEM_PROPERTY = "liquibase.should.run";
    private String changeLogFile;
    private FileOpener fileOpener;
    private Database database;
    private Logger log;
    private Map<String, Object> changeLogParameters = new HashMap<String, Object>();

    public Liquibase(String string, FileOpener fileOpener, Connection connection) throws JDBCException {
        this(string, fileOpener, DatabaseFactory.getInstance().findCorrectDatabaseImplementation(connection));
    }

    public Liquibase(String string, FileOpener fileOpener, Database database) {
        this.log = LogFactory.getLogger();
        if (string != null) {
            this.changeLogFile = string.replace('\\', '/');
        }
        this.fileOpener = fileOpener;
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public FileOpener getFileOpener() {
        return this.fileOpener;
    }

    public void setCurrentDateTimeFunction(String string) {
        if (string != null) {
            this.database.setCurrentDateTimeFunction(string);
        }
    }

    public Object getChangeLogParameterValue(String string) {
        return this.changeLogParameters.get(string);
    }

    public void setChangeLogParameterValue(String string, Object object) {
        if (!this.changeLogParameters.containsKey(string)) {
            this.changeLogParameters.put(string, object);
        }
    }

    public void update(String string) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database));
            changeLogIterator.run(new UpdateVisitor(this.database), this.database);
        }
        catch (LiquibaseException liquibaseException) {
            throw liquibaseException;
        }
        finally {
            try {
                lockHandler.releaseLock();
            }
            catch (LockException lockException) {
                this.log.log(Level.SEVERE, "Could not release lock", lockException);
            }
        }
    }

    public void update(String string, Writer writer) throws LiquibaseException {
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        JdbcOutputTemplate jdbcOutputTemplate = new JdbcOutputTemplate(writer, this.database);
        this.database.setJdbcTemplate(jdbcOutputTemplate);
        this.outputHeader("Update Database Script");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.update(string);
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        finally {
            lockHandler.releaseLock();
        }
        this.database.setJdbcTemplate(jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n, String string) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(n));
            changeLogIterator.run(new UpdateVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void update(int n, String string, Writer writer) throws LiquibaseException {
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        JdbcOutputTemplate jdbcOutputTemplate = new JdbcOutputTemplate(writer, this.database);
        this.database.setJdbcTemplate(jdbcOutputTemplate);
        this.outputHeader("Update " + n + " Change Sets Database Script");
        this.update(n, string);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        this.database.setJdbcTemplate(jdbcTemplate);
    }

    private void outputHeader(String string) throws JDBCException {
        this.database.getJdbcTemplate().comment("*********************************************************************");
        this.database.getJdbcTemplate().comment(string);
        this.database.getJdbcTemplate().comment("*********************************************************************");
        this.database.getJdbcTemplate().comment("Change Log: " + this.changeLogFile);
        this.database.getJdbcTemplate().comment("Ran at: " + DateFormat.getDateTimeInstance(3, 3).format(new Date()));
        this.database.getJdbcTemplate().comment("Against: " + this.getDatabase().getConnectionUsername() + "@" + this.getDatabase().getConnectionURL());
        this.database.getJdbcTemplate().comment("LiquiBase version: " + LiquibaseUtil.getBuildVersion());
        this.database.getJdbcTemplate().comment("*********************************************************************" + StreamUtil.getLineSeparator());
    }

    public void rollback(int n, String string, Writer writer) throws LiquibaseException {
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(new JdbcOutputTemplate(writer, this.database));
        this.outputHeader("Rollback " + n + " Change(s) Script");
        this.rollback(n, string);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        this.database.setJdbcTemplate(jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(int n, String string) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new AlreadyRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(n));
            changeLogIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            try {
                lockHandler.releaseLock();
            }
            catch (LockException lockException) {
                this.log.log(Level.SEVERE, "Error releasing lock", lockException);
            }
        }
    }

    public void rollback(String string, String string2, Writer writer) throws LiquibaseException {
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(new JdbcOutputTemplate(writer, this.database));
        this.outputHeader("Rollback to '" + string + "' Script");
        this.rollback(string, string2);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        this.database.setJdbcTemplate(jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(String string, String string2) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new AfterTagChangeSetFilter(string, this.database.getRanChangeSetList()), new ContextChangeSetFilter(string2), new DbmsChangeSetFilter(this.database));
            changeLogIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void rollback(Date date, String string, Writer writer) throws LiquibaseException {
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(new JdbcOutputTemplate(writer, this.database));
        this.outputHeader("Rollback to " + date + " Script");
        this.rollback(date, string);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        this.database.setJdbcTemplate(jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Date date, String string) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new ExecutedAfterChangeSetFilter(date, this.database.getRanChangeSetList()), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database));
            changeLogIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void changeLogSync(String string, Writer writer) throws LiquibaseException {
        JdbcOutputTemplate jdbcOutputTemplate = new JdbcOutputTemplate(writer, this.database);
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(jdbcOutputTemplate);
        this.outputHeader("SQL to add all changesets to database history table");
        this.changeLogSync(string);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        this.database.setJdbcTemplate(jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLogSync(String string) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database));
            changeLogIterator.run(new ChangeLogSyncVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void markNextChangeSetRan(String string, Writer writer) throws LiquibaseException {
        JdbcOutputTemplate jdbcOutputTemplate = new JdbcOutputTemplate(writer, this.database);
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(jdbcOutputTemplate);
        this.outputHeader("SQL to add all changesets to database history table");
        this.markNextChangeSetRan(string);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        this.database.setJdbcTemplate(jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markNextChangeSetRan(String string) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(1));
            changeLogIterator.run(new ChangeLogSyncVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureRollbackSQL(String string, Writer writer) throws LiquibaseException {
        JdbcOutputTemplate jdbcOutputTemplate = new JdbcOutputTemplate(writer, this.database);
        JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(jdbcOutputTemplate);
        this.outputHeader("SQL to roll back currently unexecuted changes");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database));
            changeLogIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            this.database.setJdbcTemplate(jdbcTemplate);
            lockHandler.releaseLock();
        }
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
    }

    public final void dropAll() throws JDBCException, LockException {
        this.dropAll(this.getDatabase().getDefaultSchemaName());
    }

    public final void dropAll(String ... stringArray) throws JDBCException {
        try {
            LockHandler.getInstance(this.database).waitForLock();
            for (String string : stringArray) {
                this.log.info("Dropping Database Objects in schema: " + this.database.convertRequestedSchemaToSchema(string));
                this.checkDatabaseChangeLogTable();
                this.getDatabase().dropDatabaseObjects(string);
                this.checkDatabaseChangeLogTable();
                this.log.finest("Objects dropped successfully");
            }
        }
        catch (JDBCException jDBCException) {
            throw jDBCException;
        }
        catch (Exception exception) {
            throw new JDBCException(exception);
        }
        finally {
            try {
                LockHandler.getInstance(this.database).releaseLock();
            }
            catch (LockException lockException) {
                this.log.severe("Unable to release lock: " + lockException.getMessage());
            }
        }
    }

    public void tag(String string) throws JDBCException {
        this.getDatabase().tag(string);
    }

    public void checkDatabaseChangeLogTable() throws JDBCException {
        this.getDatabase().checkDatabaseChangeLogTable();
        this.getDatabase().checkDatabaseChangeLogLockTable();
    }

    public boolean isSafeToRunMigration() throws JDBCException {
        return !this.getDatabase().getJdbcTemplate().executesStatements() || this.getDatabase().isLocalDatabase();
    }

    public DatabaseChangeLogLock[] listLocks() throws JDBCException, IOException, LockException {
        this.checkDatabaseChangeLogTable();
        return LockHandler.getInstance(this.getDatabase()).listLocks();
    }

    public void reportLocks(PrintStream printStream) throws LockException, IOException, JDBCException {
        DatabaseChangeLogLock[] databaseChangeLogLockArray = this.listLocks();
        printStream.println("Database change log locks for " + this.getDatabase().getConnectionUsername() + "@" + this.getDatabase().getConnectionURL());
        if (databaseChangeLogLockArray.length == 0) {
            printStream.println(" - No locks");
        }
        for (DatabaseChangeLogLock databaseChangeLogLock : databaseChangeLogLockArray) {
            printStream.println(" - " + databaseChangeLogLock.getLockedBy() + " at " + DateFormat.getDateTimeInstance().format(databaseChangeLogLock.getLockGranted()));
        }
    }

    public void forceReleaseLocks() throws LockException, IOException, JDBCException {
        this.checkDatabaseChangeLogTable();
        LockHandler.getInstance(this.getDatabase()).forceReleaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeSet> listUnrunChangeSets(String string) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(string), new DbmsChangeSetFilter(this.database));
            ListVisitor listVisitor = new ListVisitor();
            changeLogIterator.run(listVisitor, this.database);
            List<ChangeSet> list = listVisitor.getSeenChangeSets();
            return list;
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void reportStatus(boolean bl, String string, Writer writer) throws LiquibaseException {
        try {
            List<ChangeSet> list = this.listUnrunChangeSets(string);
            writer.append(String.valueOf(list.size()));
            writer.append(" change sets have not been applied to ");
            writer.append(this.getDatabase().getConnectionUsername());
            writer.append("@");
            writer.append(this.getDatabase().getConnectionURL());
            writer.append(StreamUtil.getLineSeparator());
            if (bl) {
                for (ChangeSet changeSet : list) {
                    writer.append("     ").append(changeSet.toString(false)).append(StreamUtil.getLineSeparator());
                }
            }
            writer.flush();
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCheckSums() throws LiquibaseException {
        this.log.info("Clearing database change log checksums");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            UpdateStatement updateStatement = new UpdateStatement(this.getDatabase().getDefaultSchemaName(), this.getDatabase().getDatabaseChangeLogTableName());
            updateStatement.addNewColumnValue("MD5SUM", null);
            this.getDatabase().getJdbcTemplate().execute(updateStatement, new ArrayList<SqlVisitor>());
            this.getDatabase().commit();
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void generateDocumentation(String string) throws LiquibaseException {
        this.log.info("Generating Database Documentation");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            databaseChangeLog.validate(this.database);
            ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new DbmsChangeSetFilter(this.database));
            DBDocVisitor dBDocVisitor = new DBDocVisitor(this.database);
            changeLogIterator.run(dBDocVisitor, this.database);
            dBDocVisitor.writeHTML(new File(string), this.fileOpener);
        }
        catch (IOException iOException) {
            throw new LiquibaseException(iOException);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void validate() throws LiquibaseException {
        DatabaseChangeLog databaseChangeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
        databaseChangeLog.validate(this.database);
    }
}

