/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import liquibase.FileOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemFileOpener
implements FileOpener {
    String baseDirectory;

    public FileSystemFileOpener() {
        this.baseDirectory = null;
    }

    public FileSystemFileOpener(String string) {
        if (new File(string).isFile()) {
            throw new IllegalArgumentException("base must be a directory");
        }
        this.baseDirectory = string;
    }

    @Override
    public InputStream getResourceAsStream(String string) throws IOException {
        File file;
        File file2 = new File(string);
        File file3 = file = this.baseDirectory == null ? new File(string) : new File(this.baseDirectory, string);
        if (file2.exists() && file2.isFile() && file2.isAbsolute()) {
            return new FileInputStream(file2);
        }
        if (file.exists() && file.isFile()) {
            return new FileInputStream(file);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        String string2 = new File(string).isAbsolute() || this.baseDirectory == null ? string : this.baseDirectory + File.separator + string;
        File file = new File(string2);
        if (!file.exists()) {
            return new Vector().elements();
        }
        File[] fileArray = file.listFiles();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file2 : fileArray) {
            arrayList.add(new URL("file://" + file2.getCanonicalPath()));
        }
        final Iterator iterator = arrayList.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)iterator.next();
            }
        };
    }

    @Override
    public ClassLoader toClassLoader() {
        try {
            return new URLClassLoader(new URL[]{new URL("file://" + this.baseDirectory)});
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }
}

