/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.ArrayList;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.parser.ChangeLogIterator;
import liquibase.parser.filter.DbmsChangeSetFilter;
import liquibase.parser.visitor.ValidatingVisitor;
import liquibase.preconditions.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseChangeLog
implements Comparable<DatabaseChangeLog> {
    private Preconditions preconditions = new Preconditions();
    private String physicalFilePath;
    private String logicalFilePath;
    private List<ChangeSet> changeSets = new ArrayList<ChangeSet>();

    public DatabaseChangeLog(String string) {
        this.physicalFilePath = string;
    }

    public Preconditions getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(Preconditions preconditions) {
        this.preconditions = preconditions;
    }

    public String getPhysicalFilePath() {
        return this.physicalFilePath;
    }

    public void setPhysicalFilePath(String string) {
        this.physicalFilePath = string;
    }

    public String getLogicalFilePath() {
        if (this.logicalFilePath == null) {
            return this.physicalFilePath;
        }
        return this.logicalFilePath;
    }

    public void setLogicalFilePath(String string) {
        this.logicalFilePath = string;
    }

    public String getFilePath() {
        if (this.logicalFilePath == null) {
            return this.physicalFilePath;
        }
        return this.logicalFilePath;
    }

    public String toString() {
        return this.getFilePath();
    }

    @Override
    public int compareTo(DatabaseChangeLog databaseChangeLog) {
        return this.getFilePath().compareTo(databaseChangeLog.getFilePath());
    }

    public ChangeSet getChangeSet(String string, String string2, String string3) {
        for (ChangeSet changeSet : this.changeSets) {
            if (!changeSet.getFilePath().equals(string) || !changeSet.getAuthor().equals(string2) || !changeSet.getId().equals(string3)) continue;
            return changeSet;
        }
        return null;
    }

    public List<ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public void addChangeSet(ChangeSet changeSet) {
        this.changeSets.add(changeSet);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)object;
        return this.getFilePath().equals(databaseChangeLog.getFilePath());
    }

    public int hashCode() {
        return this.getFilePath().hashCode();
    }

    public void validate(Database database) throws LiquibaseException {
        ChangeLogIterator changeLogIterator = new ChangeLogIterator(this, new DbmsChangeSetFilter(database));
        ValidatingVisitor validatingVisitor = new ValidatingVisitor(database.getRanChangeSetList());
        validatingVisitor.validate(database, this);
        changeLogIterator.run(validatingVisitor, database);
        if (!validatingVisitor.validationPassed()) {
            throw new ValidationFailedException(validatingVisitor);
        }
    }
}

