/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import liquibase.FileOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFileOpener
implements FileOpener {
    List<FileOpener> openers;

    public CompositeFileOpener(List<FileOpener> list) {
        this.openers = list;
    }

    public CompositeFileOpener(FileOpener ... fileOpenerArray) {
        this.openers = Arrays.asList(fileOpenerArray);
    }

    @Override
    public InputStream getResourceAsStream(String string) throws IOException {
        for (FileOpener fileOpener : this.openers) {
            InputStream inputStream = fileOpener.getResourceAsStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        for (FileOpener fileOpener : this.openers) {
            Enumeration<URL> enumeration = fileOpener.getResources(string);
            if (!enumeration.hasMoreElements()) continue;
            return enumeration;
        }
        return new Vector().elements();
    }

    @Override
    public ClassLoader toClassLoader() {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        for (FileOpener fileOpener : this.openers) {
            arrayList.add(fileOpener.toClassLoader());
        }
        return new CompositeClassLoader(arrayList.toArray(new ClassLoader[arrayList.size()]));
    }

    private static class CompositeClassLoader
    extends ClassLoader {
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

        public CompositeClassLoader(ClassLoader ... classLoaderArray) {
            this.classLoaders.addAll(Arrays.asList(classLoaderArray));
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            Object object = this.classLoaders.iterator();
            while (object.hasNext()) {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = object.next();
                try {
                    return classLoader2.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            object = Thread.currentThread().getContextClassLoader();
            if (object != null) {
                return ((ClassLoader)object).loadClass(string);
            }
            throw new ClassNotFoundException(string);
        }
    }
}

