/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.change.Change;
import liquibase.change.EmptyChange;
import liquibase.change.RawSQLChange;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.exception.JDBCException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.log.LogFactory;
import liquibase.preconditions.ErrorPrecondition;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Preconditions;
import liquibase.util.MD5Util;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet {
    private List<Change> changes;
    private String id;
    private String author;
    private String filePath = "UNKNOWN CHANGE LOG";
    private String physicalFilePath;
    private Logger log;
    private String md5sum;
    private boolean alwaysRun;
    private boolean runOnChange;
    private Set<String> contexts;
    private Set<String> dbmsSet;
    private Boolean failOnError;
    private Set<String> validCheckSums = new HashSet<String>();
    private boolean runInTransaction;
    private List<Change> rollBackChanges = new ArrayList<Change>();
    private String comments;
    private Preconditions rootPrecondition;
    private List<SqlVisitor> sqlVisitors = new ArrayList<SqlVisitor>();

    public boolean shouldAlwaysRun() {
        return this.alwaysRun;
    }

    public boolean shouldRunOnChange() {
        return this.runOnChange;
    }

    public ChangeSet(String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, String string6) {
        this(string, string2, bl, bl2, string3, string4, string5, string6, false);
    }

    public ChangeSet(String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, String string6, boolean bl3) {
        String[] stringArray;
        this.changes = new ArrayList<Change>();
        this.log = LogFactory.getLogger();
        this.id = string;
        this.author = string2;
        this.filePath = string3;
        this.physicalFilePath = string4;
        this.alwaysRun = bl;
        this.runOnChange = bl2;
        this.runInTransaction = bl3;
        if (StringUtils.trimToNull(string5) != null) {
            stringArray = string5.toLowerCase().split(",");
            this.contexts = new HashSet<String>();
            for (String string7 : stringArray) {
                this.contexts.add(string7.trim().toLowerCase());
            }
        }
        if (StringUtils.trimToNull(string6) != null) {
            stringArray = string6.toLowerCase().split(",");
            this.dbmsSet = new HashSet<String>();
            for (String string7 : stringArray) {
                this.dbmsSet.add(string7.trim().toLowerCase());
            }
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPhysicalFilePath() {
        if (this.physicalFilePath == null) {
            return this.filePath;
        }
        return this.physicalFilePath;
    }

    public String getMd5sum() {
        if (this.md5sum == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Change change : this.getChanges()) {
                stringBuffer.append(change.getMD5Sum()).append(":");
            }
            this.md5sum = MD5Util.computeMD5(stringBuffer.toString());
        }
        return this.md5sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Database database) throws MigrationFailedException {
        boolean bl;
        block42: {
            boolean bl2 = false;
            bl = true;
            try {
                database.setAutoCommit(!this.runInTransaction);
                database.getJdbcTemplate().comment("Changeset " + this.toString());
                if (StringUtils.trimToNull(this.getComments()) != null) {
                    Iterator<Change> iterator = this.getComments();
                    String[] object3 = ((String)((Object)iterator)).split("\n");
                    for (int i = 0; i < object3.length; ++i) {
                        if (i <= 0) continue;
                        object3[i] = database.getLineComment() + " " + object3[i];
                    }
                    database.getJdbcTemplate().comment(StringUtils.join(Arrays.asList(object3), "\n"));
                }
                if (database.getJdbcTemplate().executesStatements() && this.rootPrecondition != null) {
                    try {
                        this.rootPrecondition.check(database, null);
                    }
                    catch (PreconditionFailedException preconditionFailedException) {
                        StringBuffer exception2 = new StringBuffer();
                        exception2.append(StreamUtil.getLineSeparator());
                        for (FailedPrecondition failedPrecondition : preconditionFailedException.getFailedPreconditions()) {
                            exception2.append("          ").append(failedPrecondition.toString());
                            exception2.append(StreamUtil.getLineSeparator());
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.HALT)) {
                            preconditionFailedException.printStackTrace();
                            throw new MigrationFailedException(this, exception2.toString());
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.CONTINUE)) {
                            bl2 = true;
                            bl = false;
                            this.log.log(Level.INFO, "Continuing past ChangeSet: " + this.toString() + " due to precondition failure: " + exception2);
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.MARK_RAN)) {
                            bl2 = true;
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.WARN)) {
                            this.log.log(Level.WARNING, "Running change set despite failed precondition.  ChangeSet: " + this.toString() + ": " + exception2);
                        }
                        throw new MigrationFailedException(this, "Unexpected precondition onFail attribute: " + (Object)((Object)this.rootPrecondition.getOnFail()));
                    }
                    catch (PreconditionErrorException preconditionErrorException) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(StreamUtil.getLineSeparator());
                        for (ErrorPrecondition errorPrecondition : preconditionErrorException.getErrorPreconditions()) {
                            stringBuffer.append("          ").append(errorPrecondition.toString());
                            stringBuffer.append(StreamUtil.getLineSeparator());
                        }
                        if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.HALT)) {
                            throw new MigrationFailedException(this, stringBuffer.toString());
                        }
                        if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.CONTINUE)) {
                            bl2 = true;
                            bl = false;
                            this.log.log(Level.INFO, "Continuing past ChangeSet: " + this.toString() + " due to precondition error: " + stringBuffer);
                        } else if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.MARK_RAN)) {
                            bl2 = true;
                            bl = true;
                            this.log.log(Level.INFO, "Marking ChangeSet: " + this.toString() + " due ran to precondition error: " + stringBuffer);
                        } else if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.WARN)) {
                            this.log.log(Level.WARNING, "Running change set despite errored precondition.  ChangeSet: " + this.toString() + ": " + stringBuffer);
                        } else {
                            throw new MigrationFailedException(this, "Unexpected precondition onError attribute: " + (Object)((Object)this.rootPrecondition.getOnError()));
                        }
                        database.rollback();
                    }
                }
                if (!bl2) {
                    for (Change change : this.changes) {
                        try {
                            change.setUp();
                        }
                        catch (SetupException setupException) {
                            throw new MigrationFailedException(this, (Throwable)setupException);
                        }
                    }
                    this.log.finest("Reading ChangeSet: " + this.toString());
                    for (Change change : this.getChanges()) {
                        change.executeStatements(database, this.sqlVisitors);
                        this.log.finest(change.getConfirmationMessage());
                    }
                    if (this.runInTransaction) {
                        database.commit();
                    }
                    this.log.finest("ChangeSet " + this.toString() + " has been successfully run.");
                } else {
                    this.log.finest("Skipping ChangeSet: " + this.toString());
                }
            }
            catch (Exception exception) {
                try {
                    database.rollback();
                }
                catch (Exception exception2) {
                    throw new MigrationFailedException(this, (Throwable)exception);
                }
                if (this.getFailOnError() != null && !this.getFailOnError().booleanValue()) {
                    this.log.log(Level.INFO, "Change set " + this.toString(false) + " failed, but failOnError was false", exception);
                    break block42;
                }
                if (exception instanceof MigrationFailedException) {
                    throw (MigrationFailedException)exception;
                }
                throw new MigrationFailedException(this, (Throwable)exception);
            }
            finally {
                if (!this.runInTransaction && !database.getAutoCommitMode()) {
                    try {
                        database.setAutoCommit(false);
                    }
                    catch (JDBCException jDBCException) {
                        throw new MigrationFailedException(this, "Could not reset autocommit");
                    }
                }
            }
        }
        return bl;
    }

    public void rolback(Database database) throws RollbackFailedException {
        try {
            database.getJdbcTemplate().comment("Rolling Back ChangeSet: " + this.toString());
            if (this.rollBackChanges != null && this.rollBackChanges.size() > 0) {
                for (Change change : this.rollBackChanges) {
                    for (SqlStatement sqlStatement : change.generateStatements(database)) {
                        try {
                            database.getJdbcTemplate().execute(sqlStatement, this.sqlVisitors);
                        }
                        catch (JDBCException jDBCException) {
                            throw new RollbackFailedException("Error executing custom SQL [" + sqlStatement + "]", jDBCException);
                        }
                    }
                }
            } else {
                List<Change> list = this.getChanges();
                for (int i = list.size() - 1; i >= 0; --i) {
                    Change change = list.get(i);
                    change.executeRollbackStatements(database, this.sqlVisitors);
                    this.log.finest(change.getConfirmationMessage());
                }
            }
            database.commit();
            this.log.finest("ChangeSet " + this.toString() + " has been successfully rolled back.");
        }
        catch (Exception exception) {
            try {
                database.rollback();
            }
            catch (JDBCException jDBCException) {
                // empty catch block
            }
            throw new RollbackFailedException(exception);
        }
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public void addChange(Change change) {
        this.changes.add(change);
        change.setChangeSet(this);
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public Set<String> getDbmsSet() {
        return this.dbmsSet;
    }

    public String toString(boolean bl) {
        return this.filePath + "::" + this.getId() + "::" + this.getAuthor() + (bl ? "::(MD5Sum: " + this.getMd5sum() + ")" : "");
    }

    public String toString() {
        return this.toString(true);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public Element createNode(Document document) {
        Iterator<Change> iterator;
        Element element = document.createElement("changeSet");
        element.setAttribute("id", this.getId());
        element.setAttribute("author", this.getAuthor());
        if (this.alwaysRun) {
            element.setAttribute("alwaysRun", "true");
        }
        if (this.runOnChange) {
            element.setAttribute("runOnChange", "true");
        }
        if (this.failOnError != null) {
            element.setAttribute("failOnError", this.failOnError.toString());
        }
        if (this.getContexts() != null && this.getContexts().size() > 0) {
            iterator = new StringBuffer();
            for (String string : this.getContexts()) {
                ((StringBuffer)((Object)iterator)).append(string).append(",");
            }
            element.setAttribute("context", ((StringBuffer)((Object)iterator)).toString().replaceFirst(",$", ""));
        }
        if (this.getDbmsSet() != null && this.getDbmsSet().size() > 0) {
            iterator = new StringBuffer();
            for (String string : this.getDbmsSet()) {
                ((StringBuffer)((Object)iterator)).append(string).append(",");
            }
            element.setAttribute("dbms", ((StringBuffer)((Object)iterator)).toString().replaceFirst(",$", ""));
        }
        if (StringUtils.trimToNull(this.getComments()) != null) {
            iterator = document.createElement("comment");
            Text text = document.createTextNode(this.getComments());
            iterator.appendChild(text);
            element.appendChild((Node)((Object)iterator));
        }
        for (Change change : this.getChanges()) {
            element.appendChild(change.createNode(document));
        }
        return element;
    }

    public Change[] getRollBackChanges() {
        return this.rollBackChanges.toArray(new Change[this.rollBackChanges.size()]);
    }

    public void addRollBackSQL(String string) {
        if (StringUtils.trimToNull(string) == null) {
            this.rollBackChanges.add(new EmptyChange());
            return;
        }
        for (String string2 : StringUtils.splitSQL(string)) {
            this.rollBackChanges.add(new RawSQLChange(string2.trim()));
        }
    }

    public void addRollbackChange(Change change) throws UnsupportedChangeException {
        this.rollBackChanges.add(change);
    }

    public boolean canRollBack() {
        if (this.rollBackChanges != null && this.rollBackChanges.size() > 0) {
            return true;
        }
        for (Change change : this.getChanges()) {
            if (change.canRollBack()) continue;
            return false;
        }
        return true;
    }

    public String getDescription() {
        List<Change> list = this.getChanges();
        if (list.size() == 0) {
            return "Empty";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = null;
        int n = 0;
        for (Change change : list) {
            if (change.getClass().equals(clazz)) {
                ++n;
            } else if (n > 1) {
                stringBuffer.append(" (x").append(n).append(")");
                stringBuffer.append(", ");
                stringBuffer.append(change.getChangeName());
                n = 1;
            } else {
                stringBuffer.append(", ").append(change.getChangeName());
                n = 1;
            }
            clazz = change.getClass();
        }
        if (n > 1) {
            stringBuffer.append(" (x").append(n).append(")");
        }
        return stringBuffer.toString().replaceFirst("^, ", "");
    }

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(Boolean bl) {
        this.failOnError = bl;
    }

    public void addValidCheckSum(String string) {
        this.validCheckSums.add(string);
    }

    public boolean isCheckSumValid(String string) {
        String string2 = this.getMd5sum();
        if (string2 == null) {
            return true;
        }
        if (string == null) {
            return true;
        }
        if (string2.equals(string)) {
            return true;
        }
        for (String string3 : this.validCheckSums) {
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public Preconditions getPrecondition() {
        return this.rootPrecondition;
    }

    public void setPreconditions(Preconditions preconditions) {
        this.rootPrecondition = preconditions;
    }

    public void addSqlVisitor(SqlVisitor sqlVisitor) {
        this.sqlVisitors.add(sqlVisitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunStatus {
        NOT_RAN,
        ALREADY_RAN,
        RUN_AGAIN,
        INVALID_MD5SUM;

    }
}

