/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ServerIL;

public final class OILServerIL
implements Serializable,
Cloneable,
ServerIL {
    static final long serialVersionUID = 5576846920031604128L;
    private static Logger log = Logger.getLogger((Class)OILServerIL.class);
    private static final String LOCAL_ADDR = "org.jboss.mq.il.oil.localAddr";
    private static final String LOCAL_PORT = "org.jboss.mq.il.oil.localPort";
    private InetAddress addr;
    private int port;
    private String socketFactoryName;
    private boolean enableTcpNoDelay = false;
    private transient InetAddress localAddr;
    private transient int localPort;
    private transient ObjectInputStream in;
    private transient ObjectOutputStream out;
    private transient Socket socket;

    public OILServerIL(InetAddress addr, int port, String socketFactoryName, boolean enableTcpNoDelay) {
        this.addr = addr;
        this.port = port;
        this.socketFactoryName = socketFactoryName;
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public synchronized void setConnectionToken(ConnectionToken dest) throws Exception {
        this.checkConnection();
        this.out.writeByte(21);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(20);
        this.out.writeBoolean(enabled);
        this.waitAnswer();
    }

    public synchronized String getID() throws Exception {
        this.checkConnection();
        this.out.writeByte(16);
        return (String)this.waitAnswer();
    }

    public synchronized TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(17);
        return (TemporaryQueue)this.waitAnswer();
    }

    public synchronized TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(18);
        return (TemporaryTopic)this.waitAnswer();
    }

    public synchronized void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(8);
        item.writeExternal(this.out);
        this.waitAnswer();
    }

    public synchronized void addMessage(ConnectionToken dc, SpyMessage val) throws Exception {
        this.checkConnection();
        this.out.writeByte(9);
        SpyMessage.writeMessage(val, this.out);
        this.waitAnswer();
    }

    public synchronized SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(10);
        this.out.writeObject(dest);
        this.out.writeObject(selector);
        return (SpyMessage[])this.waitAnswer();
    }

    public synchronized void checkID(String ID) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(11);
        this.out.writeObject(ID);
        this.waitAnswer();
    }

    public synchronized String checkUser(String userName, String password) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(26);
        this.out.writeObject(userName);
        this.out.writeObject(password);
        return (String)this.waitAnswer();
    }

    public synchronized String authenticate(String userName, String password) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(30);
        this.out.writeObject(userName);
        this.out.writeObject(password);
        return (String)this.waitAnswer();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ServerIL cloneServerIL() throws Exception {
        return (ServerIL)this.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectionClosing(ConnectionToken dc) throws JMSException, Exception {
        try {
            this.checkConnection();
            this.out.writeByte(12);
            this.waitAnswer();
        }
        finally {
            this.destroyConnection();
        }
    }

    public synchronized Queue createQueue(ConnectionToken dc, String dest) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(13);
        this.out.writeObject(dest);
        return (Queue)this.waitAnswer();
    }

    public synchronized Topic createTopic(ConnectionToken dc, String dest) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(14);
        this.out.writeObject(dest);
        return (Topic)this.waitAnswer();
    }

    public synchronized void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(15);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(25);
        this.out.writeObject(id);
        this.waitAnswer();
    }

    public synchronized void ping(ConnectionToken dc, long clientTime) throws Exception {
        this.checkConnection();
        this.out.writeByte(27);
        this.out.writeLong(clientTime);
        this.waitAnswer();
    }

    public synchronized SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws Exception, Exception {
        this.checkConnection();
        this.out.writeByte(19);
        this.out.writeInt(subscriberId);
        this.out.writeLong(wait);
        return (SpyMessage)this.waitAnswer();
    }

    public synchronized void subscribe(ConnectionToken dc, Subscription s) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(22);
        this.out.writeObject(s);
        this.waitAnswer();
    }

    public synchronized void transact(ConnectionToken dc, TransactionRequest t) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(23);
        t.writeExternal(this.out);
        this.waitAnswer();
    }

    public synchronized void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException, Exception {
        this.checkConnection();
        this.out.writeByte(24);
        this.out.writeInt(subscriptionId);
        this.waitAnswer();
    }

    private void checkConnection() throws Exception {
        if (this.socket == null) {
            this.createConnection();
        }
    }

    private void createConnection() throws Exception {
        String tmp;
        boolean tracing = log.isTraceEnabled();
        if (tracing) {
            log.trace((Object)("Connecting to : " + this.addr + ":" + this.port));
        }
        SocketFactory socketFactory = null;
        if (this.socketFactoryName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(this.socketFactoryName);
                socketFactory = (SocketFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to load socket factory: " + this.socketFactoryName), (Throwable)e);
            }
        }
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        if ((tmp = System.getProperty(LOCAL_ADDR)) != null) {
            this.localAddr = InetAddress.getByName(tmp);
        }
        if ((tmp = System.getProperty(LOCAL_PORT)) != null) {
            this.localPort = Integer.parseInt(tmp);
        }
        if (tracing) {
            log.trace((Object)("Connecting with addr=" + this.addr + ", port=" + this.port + ", localAddr=" + this.localAddr + ", localPort=" + this.localPort + ", socketFactory=" + socketFactory));
        }
        this.socket = this.localAddr != null ? socketFactory.createSocket(this.addr, this.port, this.localAddr, this.localPort) : socketFactory.createSocket(this.addr, this.port);
        this.socket.setTcpNoDelay(this.enableTcpNoDelay);
        this.in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnection() throws Exception {
        try {
            this.out.close();
            this.in.close();
        }
        finally {
            this.socket.close();
        }
    }

    private Object waitAnswer() throws Exception {
        this.out.reset();
        this.out.flush();
        byte val = this.in.readByte();
        if (val == 0) {
            return null;
        }
        if (val == 1) {
            return this.in.readObject();
        }
        Exception e = (Exception)this.in.readObject();
        throw e;
    }
}

