/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;

public class TransportMappings {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$transport$TransportMappings == null ? (class$org$snmp4j$transport$TransportMappings = TransportMappings.class$("org.snmp4j.transport.TransportMappings")) : class$org$snmp4j$transport$TransportMappings);
    public static final String TRANSPORT_MAPPINGS = "org.snmp4j.transportMappings";
    private static final String TRANSPORT_MAPPINGS_DEFAULT = "transports.properties";
    private static TransportMappings instance = null;
    private Hashtable transportMappings = null;
    static /* synthetic */ Class class$org$snmp4j$transport$TransportMappings;
    static /* synthetic */ Class class$org$snmp4j$transport$DefaultUdpTransportMapping;
    static /* synthetic */ Class class$org$snmp4j$transport$DefaultTcpTransportMapping;

    protected TransportMappings() {
    }

    public static TransportMappings getInstance() {
        if (instance == null) {
            instance = new TransportMappings();
        }
        return instance;
    }

    public TransportMapping createTransportMapping(Address transportAddress) {
        Class c;
        if (this.transportMappings == null) {
            this.registerTransportMappings();
        }
        if ((c = (Class)this.transportMappings.get(transportAddress.getClass().getName())) == null) {
            return null;
        }
        Class[] params = new Class[]{transportAddress.getClass()};
        Constructor constructor = null;
        try {
            constructor = c.getConstructor(params);
            return (TransportMapping)constructor.newInstance(transportAddress);
        }
        catch (InvocationTargetException ite) {
            if (logger.isDebugEnabled()) {
                ite.printStackTrace();
            }
            logger.error(ite);
            throw new RuntimeException(ite.getTargetException());
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                ex.printStackTrace();
            }
            logger.error(ex);
            return null;
        }
    }

    protected synchronized void registerTransportMappings() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String transports;
            InputStream is = (class$org$snmp4j$transport$TransportMappings == null ? (class$org$snmp4j$transport$TransportMappings = TransportMappings.class$("org.snmp4j.transport.TransportMappings")) : class$org$snmp4j$transport$TransportMappings).getResourceAsStream(transports = System.getProperty(TRANSPORT_MAPPINGS, TRANSPORT_MAPPINGS_DEFAULT));
            if (is == null) {
                throw new InternalError("Could not read '" + transports + "' from classpath!");
            }
            Properties props = new Properties();
            try {
                props.load(is);
                Hashtable t = new Hashtable(((Hashtable)props).size());
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String addressClassName = (String)en.nextElement();
                    String className = props.getProperty(addressClassName);
                    try {
                        Class<?> c = Class.forName(className);
                        t.put(addressClassName, c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        logger.error(cnfe);
                    }
                }
                this.transportMappings = t;
            }
            catch (IOException iox) {
                String txt = "Could not read '" + transports + "': " + iox.getMessage();
                logger.error(txt);
                throw new InternalError(txt);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.warn(ex);
                }
            }
        }
        Hashtable<String, Class> t = new Hashtable<String, Class>(2);
        t.put("org.snmp4j.smi.UdpAddress", class$org$snmp4j$transport$DefaultUdpTransportMapping == null ? (class$org$snmp4j$transport$DefaultUdpTransportMapping = TransportMappings.class$("org.snmp4j.transport.DefaultUdpTransportMapping")) : class$org$snmp4j$transport$DefaultUdpTransportMapping);
        t.put("org.snmp4j.smi.TcpAddress", class$org$snmp4j$transport$DefaultTcpTransportMapping == null ? (class$org$snmp4j$transport$DefaultTcpTransportMapping = TransportMappings.class$("org.snmp4j.transport.DefaultTcpTransportMapping")) : class$org$snmp4j$transport$DefaultTcpTransportMapping);
        this.transportMappings = t;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

