/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.SMIAddress;

public class IpAddress
extends SMIAddress {
    private static final long serialVersionUID = -146846354059565449L;
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$smi$AbstractVariable == null ? (class$org$snmp4j$smi$AbstractVariable = IpAddress.class$("org.snmp4j.smi.AbstractVariable")) : class$org$snmp4j$smi$AbstractVariable);
    private static final byte[] IPANYADDRESS = new byte[]{0, 0, 0, 0};
    public static final InetAddress ANY_IPADDRESS = IpAddress.createAnyAddress();
    private InetAddress inetAddress;
    static /* synthetic */ Class class$org$snmp4j$smi$AbstractVariable;

    public IpAddress() {
        this.inetAddress = ANY_IPADDRESS;
    }

    public IpAddress(InetAddress address) {
        if (address == null) {
            throw new NullPointerException();
        }
        this.inetAddress = address;
    }

    public IpAddress(String address) {
        if (!this.parseAddress(address)) {
            throw new IllegalArgumentException(address);
        }
    }

    public int getSyntax() {
        return 64;
    }

    public boolean isValid() {
        return this.inetAddress != null;
    }

    public String toString() {
        String addressString = this.inetAddress.toString();
        return addressString.substring(addressString.indexOf(47) + 1);
    }

    public int hashCode() {
        if (this.inetAddress != null) {
            return this.inetAddress.hashCode();
        }
        return 0;
    }

    public static Address parse(String address) {
        try {
            InetAddress addr = InetAddress.getByName(address);
            return new IpAddress(addr);
        }
        catch (Exception ex) {
            logger.error("Unable to parse IpAddress from: " + address, ex);
            return null;
        }
    }

    public boolean parseAddress(String address) {
        try {
            this.inetAddress = InetAddress.getByName(address);
            return true;
        }
        catch (UnknownHostException uhex) {
            return false;
        }
    }

    public int compareTo(Object o) {
        OctetString a = new OctetString(this.inetAddress.getAddress());
        return a.compareTo(new OctetString(((IpAddress)o).getInetAddress().getAddress()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof IpAddress)) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        byte[] value = BER.decodeString(inputStream, type);
        if (type.getValue() != 64) {
            throw new IOException("Wrong type encountered when decoding Counter: " + type.getValue());
        }
        if (value.length != 4) {
            throw new IOException("IpAddress encoding error, wrong length: " + value.length);
        }
        this.inetAddress = InetAddress.getByAddress(value);
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        byte[] address = new byte[4];
        System.arraycopy(this.inetAddress.getAddress(), 0, address, 0, 4);
        BER.encodeString(outputStream, (byte)64, this.inetAddress.getAddress());
    }

    public int getBERLength() {
        return 6;
    }

    public void setAddress(byte[] rawValue) throws UnknownHostException {
        this.inetAddress = InetAddress.getByAddress(rawValue);
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    private static InetAddress createAnyAddress() {
        try {
            return InetAddress.getByAddress(IPANYADDRESS);
        }
        catch (Exception ex) {
            logger.error("Unable to create any IpAddress: " + ex.getMessage(), ex);
            return null;
        }
    }

    public Object clone() {
        return new IpAddress(this.inetAddress);
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public OID toSubIndex(boolean impliedLength) {
        byte[] address = new byte[4];
        System.arraycopy(this.inetAddress.getAddress(), 0, address, 0, 4);
        OID subIndex = new OID(new int[4]);
        for (int i = 0; i < address.length; ++i) {
            subIndex.set(i, address[i] & 0xFF);
        }
        return subIndex;
    }

    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        byte[] rawValue = new byte[4];
        for (int i = 0; i < rawValue.length; ++i) {
            rawValue[i] = (byte)(subIndex.get(i) & 0xFF);
        }
        try {
            this.setAddress(rawValue);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
    }

    public void setValue(String value) {
        if (!this.parseAddress(value)) {
            throw new IllegalArgumentException(value + " cannot be parsed by " + this.getClass().getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

