/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.DefaultTimeoutModel;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.SecureTarget;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.TimeoutModel;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.CommonTimer;

public class Snmp
implements Session,
CommandResponder {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$Snmp == null ? (class$org$snmp4j$Snmp = Snmp.class$("org.snmp4j.Snmp")) : class$org$snmp4j$Snmp);
    private MessageDispatcher messageDispatcher;
    private Map pendingRequests = new Hashtable(50);
    private Map asyncRequests = new Hashtable(50);
    private CommonTimer timer;
    private transient Vector commandResponderListeners;
    private TimeoutModel timeoutModel = new DefaultTimeoutModel();
    private NotificationDispatcher notificationDispatcher = null;
    private ReportHandler reportHandler = new ReportProcessor();
    static /* synthetic */ Class class$org$snmp4j$Snmp;

    public Snmp() {
        this.messageDispatcher = new MessageDispatcherImpl();
    }

    protected final void initMessageDispatcher() {
        this.messageDispatcher.addCommandResponder(this);
        this.messageDispatcher.addMessageProcessingModel(new MPv2c());
        this.messageDispatcher.addMessageProcessingModel(new MPv1());
        this.messageDispatcher.addMessageProcessingModel(new MPv3());
        SecurityProtocols.getInstance().addDefaultProtocols();
    }

    public Snmp(TransportMapping transportMapping) {
        this();
        this.initMessageDispatcher();
        if (transportMapping != null) {
            this.addTransportMapping(transportMapping);
        }
    }

    public Snmp(MessageDispatcher messageDispatcher, TransportMapping transportMapping) {
        this.messageDispatcher = messageDispatcher;
        this.messageDispatcher.addCommandResponder(this);
        if (transportMapping != null) {
            this.addTransportMapping(transportMapping);
        }
    }

    public Snmp(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.messageDispatcher.addCommandResponder(this);
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public void addTransportMapping(TransportMapping transportMapping) {
        this.messageDispatcher.addTransportMapping(transportMapping);
        transportMapping.addTransportListener(this.messageDispatcher);
    }

    public void removeTransportMapping(TransportMapping transportMapping) {
        this.messageDispatcher.removeTransportMapping(transportMapping);
        transportMapping.removeTransportListener(this.messageDispatcher);
    }

    public synchronized boolean addNotificationListener(Address listenAddress, CommandResponder listener) {
        TransportMapping tm = TransportMappings.getInstance().createTransportMapping(listenAddress);
        if (tm == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to add notification listener for address: " + listenAddress);
            }
            return false;
        }
        if (tm instanceof ConnectionOrientedTransportMapping) {
            ((ConnectionOrientedTransportMapping)tm).setConnectionTimeout(0L);
        }
        tm.addTransportListener(this.messageDispatcher);
        if (this.notificationDispatcher == null) {
            this.notificationDispatcher = new NotificationDispatcher();
            this.addCommandResponder(this.notificationDispatcher);
        }
        this.notificationDispatcher.addNotificationListener(listenAddress, tm, listener);
        try {
            tm.listen();
            if (logger.isInfoEnabled()) {
                logger.info("Added notification listener for address: " + listenAddress);
            }
            return true;
        }
        catch (IOException ex) {
            logger.warn("Failed to initialize notification listener for address '" + listenAddress + "': " + ex.getMessage());
            return false;
        }
    }

    public synchronized boolean removeNotificationListener(Address listenAddress) {
        if (this.notificationDispatcher != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Removing notification listener for address: " + listenAddress);
            }
            return this.notificationDispatcher.removeNotificationListener(listenAddress);
        }
        return false;
    }

    public void listen() throws IOException {
        Iterator it = this.messageDispatcher.getTransportMappings().iterator();
        while (it.hasNext()) {
            TransportMapping tm = (TransportMapping)it.next();
            if (tm.isListening()) continue;
            tm.listen();
        }
    }

    public int getNextRequestID() {
        return this.messageDispatcher.getNextRequestID();
    }

    public void close() throws IOException {
        Iterator it = this.messageDispatcher.getTransportMappings().iterator();
        while (it.hasNext()) {
            TransportMapping tm = (TransportMapping)it.next();
            if (!tm.isListening()) continue;
            tm.close();
        }
        CommonTimer t = this.timer;
        this.timer = null;
        if (t != null) {
            t.cancel();
        }
        Iterator it2 = this.pendingRequests.values().iterator();
        while (it2.hasNext()) {
            PendingRequest pending = (PendingRequest)it2.next();
            ResponseEvent e = new ResponseEvent(this, null, pending.pdu, null, pending.userObject, new InterruptedException("Snmp session has been closed"));
            pending.listener.onResponse(e);
        }
        if (this.notificationDispatcher != null) {
            this.notificationDispatcher.closeAll();
        }
    }

    public ResponseEvent get(PDU pdu, Target target) throws IOException {
        pdu.setType(-96);
        return this.send(pdu, target);
    }

    public void get(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-96);
        this.send(pdu, target, userHandle, listener);
    }

    public ResponseEvent getNext(PDU pdu, Target target) throws IOException {
        pdu.setType(-95);
        return this.send(pdu, target);
    }

    public void getNext(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-95);
        this.send(pdu, target, userHandle, listener);
    }

    public ResponseEvent getBulk(PDU pdu, Target target) throws IOException {
        pdu.setType(-91);
        return this.send(pdu, target);
    }

    public void getBulk(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-91);
        this.send(pdu, target, userHandle, listener);
    }

    public ResponseEvent inform(PDU pdu, Target target) throws IOException {
        pdu.setType(-90);
        return this.send(pdu, target);
    }

    public void inform(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-90);
        this.send(pdu, target, userHandle, listener);
    }

    public void trap(PDUv1 pdu, Target target) throws IOException {
        if (target.getVersion() != 0) {
            throw new IllegalArgumentException("SNMPv1 trap PDU must be used with SNMPv1");
        }
        pdu.setType(-92);
        this.send(pdu, target);
    }

    public void notify(PDU pdu, Target target) throws IOException {
        if (target.getVersion() == 0) {
            throw new IllegalArgumentException("Notifications PDUs cannot be used with SNMPv1");
        }
        pdu.setType(-89);
        this.send(pdu, target);
    }

    public ResponseEvent set(PDU pdu, Target target) {
        pdu.setType(-93);
        try {
            return this.send(pdu, target);
        }
        catch (IOException ex) {
            return new ResponseEvent(this, null, pdu, null, target, ex);
        }
    }

    public void set(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-93);
        this.send(pdu, target, userHandle, listener);
    }

    public ResponseEvent send(PDU pdu, Target target) throws IOException {
        return this.send(pdu, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEvent send(PDU pdu, Target target, TransportMapping transport) throws IOException {
        if (!pdu.isConfirmedPdu()) {
            this.sendMessage(pdu, target, transport, null);
            return null;
        }
        if (this.timer == null) {
            this.createPendingTimer();
        }
        SyncResponseListener syncResponse = new SyncResponseListener();
        PendingRequest retryRequest = null;
        SyncResponseListener syncResponseListener = syncResponse;
        synchronized (syncResponseListener) {
            PduHandle handle = null;
            PendingRequest request = new PendingRequest(syncResponse, target, pdu, target, transport);
            handle = this.sendMessage(pdu, target, transport, request);
            try {
                syncResponse.wait();
                retryRequest = (PendingRequest)this.pendingRequests.remove(handle);
                if (logger.isDebugEnabled()) {
                    logger.debug("Removed pending request with handle: " + handle);
                }
                request.setFinished();
                request.cancel();
            }
            catch (InterruptedException iex) {
                logger.warn(iex);
            }
        }
        if (retryRequest != null) {
            retryRequest.setFinished();
            retryRequest.cancel();
        }
        return syncResponse.response;
    }

    private synchronized void createPendingTimer() {
        if (this.timer == null) {
            this.timer = SNMP4JSettings.getTimerFactory().createTimer();
        }
    }

    public void send(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        this.send(pdu, target, null, userHandle, listener);
    }

    public void send(PDU pdu, Target target, TransportMapping transport, Object userHandle, ResponseListener listener) throws IOException {
        if (!pdu.isConfirmedPdu()) {
            this.sendMessage(pdu, target, transport, null);
            return;
        }
        if (this.timer == null) {
            this.createPendingTimer();
        }
        AsyncPendingRequest request = new AsyncPendingRequest(listener, userHandle, pdu, target, transport);
        this.sendMessage(pdu, target, transport, request);
    }

    public PDU sendPDU(PDU pdu, Target target) throws IOException {
        ResponseEvent e = this.send(pdu, target);
        if (e != null) {
            return e.getResponse();
        }
        return null;
    }

    public void sendPDU(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        this.send(pdu, target, userHandle, listener);
    }

    protected PduHandle sendMessage(PDU pdu, Target target, TransportMapping transport, PduHandleCallback pduHandleCallback) throws IOException {
        PduHandle handle = null;
        if (target instanceof SecureTarget) {
            SecureTarget secureTarget = (SecureTarget)target;
            handle = this.messageDispatcher.sendPdu(transport, secureTarget.getAddress(), secureTarget.getVersion(), secureTarget.getSecurityModel(), secureTarget.getSecurityName().getValue(), secureTarget.getSecurityLevel(), pdu, true, pduHandleCallback);
        } else if (target instanceof CommunityTarget) {
            CommunityTarget communityTarget = (CommunityTarget)target;
            int securityModel = 2;
            if (communityTarget.getVersion() == 0) {
                securityModel = 1;
            }
            handle = this.messageDispatcher.sendPdu(transport, communityTarget.getAddress(), communityTarget.getVersion(), securityModel, communityTarget.getCommunity().getValue(), 1, pdu, true, pduHandleCallback);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(PDU request, ResponseListener listener) {
        PendingRequest pendingRequest;
        AsyncRequestKey key = new AsyncRequestKey(request, listener);
        PduHandle pending = (PduHandle)this.asyncRequests.remove(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Cancelling pending request with handle " + pending);
        }
        if (pending != null && (pendingRequest = (PendingRequest)this.pendingRequests.remove(pending)) != null) {
            PendingRequest pendingRequest2 = pendingRequest;
            synchronized (pendingRequest2) {
                pendingRequest.setFinished();
                pendingRequest.cancel();
            }
        }
    }

    public void setLocalEngine(byte[] engineID, int engineBoots, int engineTime) {
        MPv3 mpv3 = this.getMPv3();
        mpv3.setLocalEngineID(engineID);
        USM usm = (USM)mpv3.getSecurityModel(3);
        usm.setLocalEngine(new OctetString(engineID), engineBoots, engineTime);
    }

    public byte[] getLocalEngineID() {
        return this.getMPv3().getLocalEngineID();
    }

    private MPv3 getMPv3() {
        MPv3 mpv3 = (MPv3)this.getMessageProcessingModel(3);
        if (mpv3 == null) {
            throw new NoSuchElementException("MPv3 not available");
        }
        return mpv3;
    }

    public byte[] discoverAuthoritativeEngineID(Address address, long timeout) {
        USM usm;
        MPv3 mpv3 = this.getMPv3();
        OctetString engineID = mpv3.removeEngineID(address);
        if (engineID != null && (usm = this.getUSM()) != null) {
            usm.removeEngineTime(engineID);
        }
        ScopedPDU scopedPDU = new ScopedPDU();
        scopedPDU.setType(-96);
        UserTarget target = new UserTarget();
        target.setTimeout(timeout);
        target.setAddress(address);
        try {
            this.send(scopedPDU, target);
            OctetString authoritativeEngineID = mpv3.getEngineID(address);
            if (authoritativeEngineID == null) {
                return null;
            }
            return new OctetString(authoritativeEngineID.getValue()).getValue();
        }
        catch (IOException ex) {
            logger.error("IO error while trying to discover authoritative engine ID: " + ex);
            return null;
        }
    }

    public USM getUSM() {
        return (USM)SecurityModels.getInstance().getSecurityModel(new Integer32(3));
    }

    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        return this.messageDispatcher.getMessageProcessingModel(messageProcessingModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPdu(CommandResponderEvent event) {
        PduHandle handle = event.getPduHandle();
        PDU pdu = event.getPDU();
        if (pdu.getType() == -94) {
            PendingRequest request;
            event.setProcessed(true);
            if (logger.isDebugEnabled()) {
                logger.debug("Looking up pending request with handle " + handle);
            }
            Map map = this.pendingRequests;
            synchronized (map) {
                request = (PendingRequest)this.pendingRequests.get(handle);
                if (request != null) {
                    request.responseReceived();
                }
            }
            if (request == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Received response that cannot be matched to any outstanding request, address=" + event.getPeerAddress() + ", requestID=" + pdu.getRequestID());
                }
            } else {
                request.listener.onResponse(new ResponseEvent(this, event.getPeerAddress(), request.pdu, pdu, request.userObject));
            }
        } else if (pdu.getType() == -88) {
            event.setProcessed(true);
            this.reportHandler.processReport(handle, event);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Fire process PDU event: " + event.toString());
            }
            this.fireProcessPdu(event);
        }
    }

    public synchronized void removeCommandResponder(CommandResponder listener) {
        if (this.commandResponderListeners != null && this.commandResponderListeners.contains(listener)) {
            Vector v = (Vector)this.commandResponderListeners.clone();
            v.removeElement(listener);
            this.commandResponderListeners = v;
        }
    }

    public synchronized void addCommandResponder(CommandResponder listener) {
        Vector v;
        Vector vector = v = this.commandResponderListeners == null ? new Vector(2) : (Vector)this.commandResponderListeners.clone();
        if (!v.contains(listener)) {
            v.addElement(listener);
            this.commandResponderListeners = v;
        }
    }

    protected void fireProcessPdu(CommandResponderEvent event) {
        if (this.commandResponderListeners != null) {
            Vector listeners = this.commandResponderListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((CommandResponder)listeners.elementAt(i)).processPdu(event);
                if (!event.isProcessed()) continue;
                return;
            }
        }
    }

    public TimeoutModel getTimeoutModel() {
        return this.timeoutModel;
    }

    public ReportHandler getReportHandler() {
        return this.reportHandler;
    }

    public void setTimeoutModel(TimeoutModel timeoutModel) {
        if (timeoutModel == null) {
            throw new NullPointerException("Timeout model cannot be null");
        }
        this.timeoutModel = timeoutModel;
    }

    public void setReportHandler(ReportHandler reportHandler) {
        if (reportHandler == null) {
            throw new IllegalArgumentException("ReportHandler must not be null");
        }
        this.reportHandler = reportHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NotificationDispatcher
    implements CommandResponder {
        private Hashtable notificationListeners = new Hashtable(10);
        private Hashtable notificationTransports = new Hashtable(10);

        protected NotificationDispatcher() {
        }

        public synchronized void addNotificationListener(Address listenAddress, TransportMapping transport, CommandResponder listener) {
            this.notificationListeners.put(listenAddress, transport);
            this.notificationTransports.put(transport, listener);
        }

        public synchronized boolean removeNotificationListener(Address listenAddress) {
            block3: {
                TransportMapping tm = (TransportMapping)this.notificationListeners.remove(listenAddress);
                if (tm == null) {
                    return false;
                }
                tm.removeTransportListener(Snmp.this.messageDispatcher);
                this.notificationTransports.remove(tm);
                try {
                    tm.close();
                }
                catch (IOException ex) {
                    logger.error(ex);
                    if (!logger.isDebugEnabled()) break block3;
                    ex.printStackTrace();
                }
            }
            return true;
        }

        public synchronized void closeAll() {
            this.notificationTransports.clear();
            Iterator it = this.notificationListeners.values().iterator();
            while (it.hasNext()) {
                TransportMapping tm = (TransportMapping)it.next();
                try {
                    tm.close();
                }
                catch (IOException ex) {
                    logger.error(ex);
                    if (!logger.isDebugEnabled()) continue;
                    ex.printStackTrace();
                }
            }
            this.notificationListeners.clear();
        }

        public synchronized void processPdu(CommandResponderEvent event) {
            CommandResponder listener;
            block4: {
                listener = (CommandResponder)this.notificationTransports.get(event.getTransportMapping());
                if (event.getPDU() != null && event.getPDU().getType() == -90) {
                    try {
                        this.sendInformResponse(event);
                    }
                    catch (MessageException mex) {
                        if (!logger.isWarnEnabled()) break block4;
                        logger.warn("Failed to send response on INFORM PDU event (" + event + "): " + mex.getMessage());
                    }
                }
            }
            if (listener != null) {
                listener.processPdu(event);
            }
        }

        protected void sendInformResponse(CommandResponderEvent event) throws MessageException {
            PDU responsePDU = (PDU)event.getPDU().clone();
            responsePDU.setType(-94);
            responsePDU.setErrorStatus(0);
            responsePDU.setErrorIndex(0);
            Snmp.this.messageDispatcher.returnResponsePdu(event.getMessageProcessingModel(), event.getSecurityModel(), event.getSecurityName(), event.getSecurityLevel(), responsePDU, event.getMaxSizeResponsePDU(), event.getStateReference(), new StatusInformation());
        }
    }

    static class SyncResponseListener
    implements ResponseListener {
        private ResponseEvent response = null;

        SyncResponseListener() {
        }

        public synchronized void onResponse(ResponseEvent event) {
            this.response = event;
            this.notify();
        }

        public ResponseEvent getResponse() {
            return this.response;
        }
    }

    static class AsyncRequestKey {
        private PDU request;
        private ResponseListener listener;

        public AsyncRequestKey(PDU request, ResponseListener listener) {
            this.request = request;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AsyncRequestKey) {
                AsyncRequestKey other = (AsyncRequestKey)obj;
                return this.request.equals(other.request) && this.listener.equals(other.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.request.hashCode();
        }
    }

    class AsyncPendingRequest
    extends PendingRequest {
        public AsyncPendingRequest(ResponseListener listener, Object userObject, PDU pdu, Target target, TransportMapping transport) {
            super(listener, userObject, pdu, target, transport);
        }

        protected void registerRequest(PduHandle handle) {
            AsyncRequestKey key = new AsyncRequestKey(this.pdu, this.listener);
            Snmp.this.asyncRequests.put(key, handle);
        }
    }

    class PendingRequest
    extends TimerTask
    implements PduHandleCallback {
        private PduHandle key;
        protected int retryCount;
        protected ResponseListener listener;
        protected Object userObject;
        protected PDU pdu;
        protected Target target;
        protected TransportMapping transport;
        private int requestStatus = 0;
        private int maxRequestStatus = 2;
        private volatile boolean finished = false;
        private volatile boolean responseReceived = false;

        public PendingRequest(ResponseListener listener, Object userObject, PDU pdu, Target target, TransportMapping transport) {
            this.userObject = userObject;
            this.listener = listener;
            this.retryCount = target.getRetries();
            this.pdu = pdu;
            this.target = (Target)target.clone();
            this.transport = transport;
        }

        private PendingRequest(PendingRequest other) {
            this.userObject = other.userObject;
            this.listener = other.listener;
            this.retryCount = other.retryCount - 1;
            this.pdu = other.pdu;
            this.target = other.target;
            this.requestStatus = other.requestStatus;
            this.responseReceived = other.responseReceived;
            this.transport = other.transport;
        }

        protected void registerRequest(PduHandle handle) {
        }

        public void responseReceived() {
            this.responseReceived = true;
        }

        public synchronized void pduHandleAssigned(PduHandle handle, Object pdu) {
            if (this.key == null) {
                this.key = handle;
                Snmp.this.pendingRequests.put(handle, this);
                this.registerRequest(handle);
                if (logger.isDebugEnabled()) {
                    logger.debug("Running pending " + (this.listener instanceof SyncResponseListener ? "sync" : "async") + " request with handle " + handle + " and retry count left " + this.retryCount);
                }
                long delay = Snmp.this.timeoutModel.getRetryTimeout(this.target.getRetries() - this.retryCount, this.target.getRetries(), this.target.getTimeout());
                if (!this.finished && !this.responseReceived) {
                    Snmp.this.timer.schedule(this, delay);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                boolean retry;
                Map map = Snmp.this.pendingRequests;
                synchronized (map) {
                    retry = !this.finished && this.retryCount > 0 && !this.responseReceived;
                }
                if (retry) {
                    try {
                        PendingRequest nextRetry = new PendingRequest(this);
                        Snmp.this.sendMessage(this.pdu, this.target, this.transport, nextRetry);
                    }
                    catch (IOException ex) {
                        this.finished = true;
                        logger.error("Failed to send SNMP message to " + this.target.toString() + ": " + ex.getMessage());
                        Snmp.this.messageDispatcher.releaseStateReference(this.target.getVersion(), this.key);
                        this.listener.onResponse(new ResponseEvent(Snmp.this, null, this.pdu, null, this.userObject, ex));
                    }
                } else if (!this.finished) {
                    this.finished = true;
                    Snmp.this.pendingRequests.remove(this.key);
                    if (!this.responseReceived) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Request timed out: " + this.key.getTransactionID());
                        }
                        Snmp.this.messageDispatcher.releaseStateReference(this.target.getVersion(), this.key);
                        this.listener.onResponse(new ResponseEvent(Snmp.this, null, this.pdu, null, this.userObject));
                    }
                } else {
                    Snmp.this.pendingRequests.remove(this.key);
                }
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                logger.error("Failed to process pending request " + this.key + " because " + ex.getMessage(), ex);
                throw ex;
            }
            catch (Error er) {
                if (logger.isDebugEnabled()) {
                    er.printStackTrace();
                }
                logger.fatal("Failed to process pending request " + this.key + " because " + er.getMessage(), er);
                throw er;
            }
        }

        public boolean setFinished() {
            boolean currentState = this.finished;
            this.finished = true;
            return currentState;
        }

        public void setMaxRepuestStatus(int maxRepuestStatus) {
            this.maxRequestStatus = maxRepuestStatus;
        }

        public int getMaxRepuestStatus() {
            return this.maxRequestStatus;
        }

        public boolean isResponseReceived() {
            return this.responseReceived;
        }
    }

    class ReportProcessor
    implements ReportHandler {
        ReportProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processReport(PduHandle handle, CommandResponderEvent e) {
            boolean intime;
            PDU pdu = e.getPDU();
            logger.debug("Searching pending request with handle" + handle);
            PendingRequest request = (PendingRequest)Snmp.this.pendingRequests.get(handle);
            if (request == null) {
                logger.warn("Unmatched report PDU received from " + e.getPeerAddress());
                return;
            }
            if (pdu.size() == 0) {
                logger.error("Illegal report PDU received from " + e.getPeerAddress() + " missing report variable binding");
                return;
            }
            VariableBinding vb = pdu.get(0);
            if (vb == null) {
                logger.error("Received illegal REPORT PDU from " + e.getPeerAddress());
                return;
            }
            OID firstOID = vb.getOid();
            boolean resend = false;
            if (request.requestStatus < request.maxRequestStatus) {
                switch (request.requestStatus) {
                    case 0: {
                        if (SnmpConstants.usmStatsUnknownEngineIDs.equals(firstOID)) {
                            resend = true;
                            break;
                        }
                        if (!SnmpConstants.usmStatsNotInTimeWindows.equals(firstOID)) break;
                        request.requestStatus++;
                        resend = true;
                        break;
                    }
                    case 1: {
                        if (!SnmpConstants.usmStatsNotInTimeWindows.equals(firstOID)) break;
                        resend = true;
                    }
                }
            }
            if (resend) {
                logger.debug("Send new request after report.");
                request.requestStatus++;
                try {
                    PduHandle resentHandle = Snmp.this.sendMessage(request.pdu, request.target, e.getTransportMapping(), null);
                    request.key = resentHandle;
                }
                catch (IOException iox) {
                    logger.error("Failed to send message to " + request.target + ": " + iox.getMessage());
                    return;
                }
            }
            PendingRequest pendingRequest = request;
            synchronized (pendingRequest) {
                intime = request.cancel();
            }
            Snmp.this.pendingRequests.remove(handle);
            if (intime) {
                request.listener.onResponse(new ResponseEvent(this, e.getPeerAddress(), request.pdu, pdu, request.userObject));
            } else if (logger.isInfoEnabled()) {
                logger.info("Received late report from " + e.getPeerAddress() + " with request ID " + pdu.getRequestID());
            }
        }
    }

    public static interface ReportHandler {
        public void processReport(PduHandle var1, CommandResponderEvent var2);
    }
}

