/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLburpRequest;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.LBEREncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class LburpOperationRequest
extends LDAPExtendedOperation {
    int currSize;

    public LburpOperationRequest(LDAPLburpRequest[] lDAPLburpRequestArray, int n) throws LDAPException {
        super("2.16.840.1.113719.1.142.100.6", null);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LBEREncoder lBEREncoder = new LBEREncoder();
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            ASN1Integer aSN1Integer = new ASN1Integer(n);
            aSN1Sequence.add(aSN1Integer);
            this.currSize = 0;
            while (this.currSize < lDAPLburpRequestArray.length && lDAPLburpRequestArray[this.currSize] != null) {
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                switch (lDAPLburpRequestArray[this.currSize].opType) {
                    case 6: 
                    case 8: 
                    case 12: {
                        ASN1Sequence aSN1Sequence3 = lDAPLburpRequestArray[this.currSize].getRequestASN1Sequence();
                        aSN1Sequence2.add(aSN1Sequence3);
                        break;
                    }
                    case 10: {
                        ASN1OctetString aSN1OctetString = lDAPLburpRequestArray[this.currSize].getRequestASN1OcString();
                        ASN1Identifier aSN1Identifier = new ASN1Identifier(0, true, 10);
                        aSN1Sequence2.add(aSN1OctetString);
                        break;
                    }
                }
                ASN1SequenceOf aSN1SequenceOf = lDAPLburpRequestArray[this.currSize].getControlsASN1Object();
                if (aSN1SequenceOf != null) {
                    aSN1Sequence2.add(aSN1SequenceOf);
                }
                ++this.currSize;
                aSN1Sequence.add(aSN1Sequence2);
            }
            aSN1Sequence.encode(lBEREncoder, byteArrayOutputStream);
            this.setValue(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new LDAPException("ENCODING_ERROR", 83, null);
        }
    }

    static {
        try {
            LDAPExtendedResponse.register("2.16.840.1.113719.1.142.100.7", Class.forName("com.novell.ldap.extensions.LburpOperationResponse"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not register Extended Response - Class not found");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

