/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.ReferralAddress;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SecurityEquivalenceEventData
implements EventResponseData {
    private String entryDN;
    private int retryCount;
    private String valueDN;
    private int referralCount;
    private List referralList = Collections.EMPTY_LIST;

    public SecurityEquivalenceEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.entryDN = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.retryCount = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.valueDN = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byteArrayInputStream, nArray);
        this.referralCount = ((ASN1Integer)aSN1Sequence.get(0)).intValue();
        if (this.referralCount > 0) {
            this.referralList = new ArrayList();
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(1);
            for (int i = 0; i < this.referralCount; ++i) {
                this.referralList.add(new ReferralAddress((ASN1Sequence)aSN1Sequence2.get(i)));
            }
        }
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public int getReferralCount() {
        return this.referralCount;
    }

    public List getReferralList() {
        return this.referralList;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getValueDN() {
        return this.valueDN;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SecurityEquivalenceEventData");
        stringBuffer.append("(EntryDN =" + this.getEntryDN() + ")");
        stringBuffer.append("(RetryCount =" + this.getRetryCount() + ")");
        stringBuffer.append("(valueDN =" + this.getValueDN() + ")");
        stringBuffer.append("(referralCount" + this.getReferralCount() + ")");
        stringBuffer.append("(Referral Lists =" + this.getReferralList() + ")");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

