/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.daemon;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.model.ServiceDaemon;

public abstract class AbstractServiceDaemon
implements ServiceDaemon,
SpringServiceDaemon {
    private int m_status;
    private String m_name;
    private Object m_statusLock = new Object();

    public final void afterPropertiesSet() throws Exception {
        this.init();
    }

    protected abstract void onInit();

    protected void onPause() {
    }

    protected void onResume() {
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    public final String getName() {
        return this.m_name;
    }

    protected AbstractServiceDaemon(String name) {
        this.m_name = name;
        this.setStatus(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(int status) {
        Object object = this.m_statusLock;
        synchronized (object) {
            this.m_status = status;
            this.m_statusLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForStatus(int status, long timeout) throws InterruptedException {
        Object object = this.m_statusLock;
        synchronized (object) {
            long now;
            long last = System.currentTimeMillis();
            for (long waitTime = timeout; status != this.m_status && waitTime > 0L; waitTime -= now - last) {
                this.m_statusLock.wait(waitTime);
                now = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForStatus(int status) throws InterruptedException {
        Object object = this.m_statusLock;
        synchronized (object) {
            while (status != this.m_status) {
                this.m_statusLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        Object object = this.m_statusLock;
        synchronized (object) {
            return this.m_status;
        }
    }

    public String getStatusText() {
        return STATUS_NAMES[this.getStatus()];
    }

    public String status() {
        return this.getStatusText();
    }

    protected synchronized boolean isStartPending() {
        return this.getStatus() == 0;
    }

    protected synchronized boolean isRunning() {
        return this.getStatus() == 2;
    }

    protected synchronized boolean isPaused() {
        return this.getStatus() == 6;
    }

    protected synchronized boolean isStarting() {
        return this.getStatus() == 1;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected void fatalf(String format, Object ... args) {
        this.log().fatal(String.format(format, args));
    }

    protected void fatalf(Throwable t, String format, Object ... args) {
        this.log().fatal(String.format(format, args), t);
    }

    protected void errorf(String format, Object ... args) {
        this.log().error(String.format(format, args));
    }

    protected void errorf(Throwable t, String format, Object ... args) {
        this.log().error(String.format(format, args), t);
    }

    protected void warnf(String format, Object ... args) {
        this.log().warn(String.format(format, args));
    }

    protected void warnf(Throwable t, String format, Object ... args) {
        this.log().warn(String.format(format, args), t);
    }

    protected void infof(String format, Object ... args) {
        if (this.log().isInfoEnabled()) {
            this.log().info(String.format(format, args));
        }
    }

    protected void infof(Throwable t, String format, Object ... args) {
        if (this.log().isInfoEnabled()) {
            this.log().info(String.format(format, args), t);
        }
    }

    protected void debugf(String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(String.format(format, args));
        }
    }

    protected void debugf(Throwable t, String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(String.format(format, args), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.log().debug(this.getName() + " initializing.");
            this.onInit();
            this.log().debug(this.getName() + " initialization complete.");
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            if (!this.isRunning()) {
                return;
            }
            this.setStatus(5);
            this.onPause();
            this.setStatus(6);
            this.log().debug(this.getName() + " paused.");
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            if (!this.isPaused()) {
                return;
            }
            this.setStatus(7);
            this.onResume();
            this.setStatus(2);
            this.log().debug(this.getName() + " resumed.");
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.log().debug(this.getName() + " starting.");
            this.setStatus(1);
            this.onStart();
            this.setStatus(2);
            this.log().info(this.getName() + " started.");
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.log().debug(this.getName() + " stopping.");
            this.setStatus(3);
            this.onStop();
            this.setStatus(4);
            this.log().info(this.getName() + " stopped.");
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }
}

