/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.opennms.core.utils.ThreadCategory;

public class ConnectorFactory {
    private static Semaphore s_available;
    private static Executor s_executor;

    public SocketConnector getConnector() throws InterruptedException {
        if (s_available != null) {
            s_available.acquire();
        }
        return this.createConnector();
    }

    public void dispose(final SocketConnector connector) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ThreadCategory.getInstance(ConnectorFactory.class).debug("Disposing the connector");
                try {
                    connector.dispose();
                }
                finally {
                    if (s_available != null) {
                        s_available.release();
                    }
                }
            }
        };
        s_executor.execute(r);
    }

    private SocketConnector createConnector() throws InterruptedException {
        return new NioSocketConnector();
    }

    static {
        if (System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnectors") != null) {
            s_available = Integer.parseInt(System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnectors")) == 0 ? null : new Semaphore(Integer.parseInt(System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnectors", "2000")));
        }
        s_executor = Executors.newSingleThreadExecutor();
    }
}

